/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.dex.dexopt.DexProfileData;
import com.reandroid.dex.dexopt.HotMethodRegionList;
import com.reandroid.dex.dexopt.MethodBitmap;
import com.reandroid.dex.dexopt.ProfileClassList;
import com.reandroid.dex.dexopt.ProfileDataHeader;

public class DexProfileDataVersionP
extends DexProfileData {
    private final ProfileDataHeader header;
    private final HotMethodRegionList hotMethodList;
    private final ProfileClassList classList;
    private final MethodBitmap methodBitmap;

    public DexProfileDataVersionP(ProfileDataHeader header) {
        super(3);
        this.header = header;
        this.hotMethodList = new HotMethodRegionList(header.hotMethodRegionSize);
        this.classList = new ProfileClassList(header.classSetSize);
        this.methodBitmap = new MethodBitmap(header.numMethodIds);
        this.addChild(0, this.hotMethodList);
        this.addChild(1, this.classList);
        this.addChild(2, this.methodBitmap);
    }

    @Override
    public String getName() {
        return this.header().name.get();
    }

    @Override
    public void setName(String name) {
        this.header().name.set(name);
    }

    public ProfileDataHeader header() {
        return this.header;
    }

    @Override
    public long getChecksum() {
        return (long)this.header.dexChecksum.get() & 0xFFFFFFFFL;
    }

    @Override
    public void setChecksum(long crc32) {
        this.header().dexChecksum.set((int)crc32);
    }

    @Override
    public HotMethodRegionList hotMethodList() {
        return this.hotMethodList;
    }

    @Override
    public ProfileClassList classList() {
        return this.classList;
    }

    @Override
    public MethodBitmap methodBitmap() {
        return this.methodBitmap;
    }
}

