/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.dexopt.InlineCache;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;
import java.util.Iterator;

public class HotMethodRegion
extends FixedBlockContainer
implements LinkableProfileItem,
Comparable<HotMethodRegion>,
JSONConvert<JSONObject> {
    private final IntegerReference diffWithLastMethodDexIndex = new ShortItem();
    private final BlockList<InlineCache> inlineCacheList;
    private int idx;
    private MethodKey methodKey;
    private boolean invalid;
    public static final Creator<HotMethodRegion> CREATOR = HotMethodRegion::new;

    public HotMethodRegion() {
        super(3);
        ShortItem inlineCacheSize = new ShortItem();
        this.inlineCacheList = new CountedBlockList<InlineCache>(InlineCache.CREATOR, inlineCacheSize);
        this.idx = -1;
        this.addChild(0, (Block)((Object)this.diffWithLastMethodDexIndex));
        this.addChild(1, inlineCacheSize);
        this.addChild(2, this.inlineCacheList);
    }

    public MethodKey getKey() {
        return this.methodKey;
    }

    public void setKey(Key key) {
        this.methodKey = (MethodKey)key;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    public int size() {
        return this.inlineCacheList.size();
    }

    public InlineCache get(int i) {
        return this.inlineCacheList.get(i);
    }

    public Iterator<InlineCache> iterator() {
        return this.inlineCacheList.iterator();
    }

    public IntegerReference diffWithLastMethodDexIndex() {
        return this.diffWithLastMethodDexIndex;
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public void link(DexFile dexFile) {
        MethodId methodId = dexFile.getItem(SectionType.METHOD_ID, this.getIdx());
        if (methodId != null) {
            this.setKey(methodId.getKey());
            this.invalid = false;
        } else {
            this.invalid = true;
        }
        LinkableProfileItem.linkAll(dexFile, this.iterator());
    }

    @Override
    public void update(DexFile dexFile) {
        MethodId methodId = dexFile.getItem(SectionType.METHOD_ID, this.getKey());
        if (methodId != null) {
            this.setIdx(methodId.getIdx());
            this.invalid = false;
        } else {
            this.invalid = true;
        }
        LinkableProfileItem.updateAll(dexFile, this.iterator());
    }

    @Override
    public int compareTo(HotMethodRegion region) {
        if (region == this) {
            return 0;
        }
        return CompareUtil.compare(this.getIdx(), region.getIdx());
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        if (this.isInvalid()) {
            jsonObject.put("invalid", true);
        }
        jsonObject.put("id", this.getIdx());
        MethodKey key = this.getKey();
        if (key != null) {
            jsonObject.put("key", key.toString());
        }
        jsonObject.put("inline_caches", BlockList.toJsonArray(this.inlineCacheList));
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.invalid = json.optBoolean("invalid", false);
        this.setIdx(json.getInt("id"));
        this.setKey(MethodKey.parse(json.optString("key")));
        BlockList.fromJsonArray(this.inlineCacheList, json.optJSONArray("inline_caches"));
    }

    public String toString() {
        MethodKey key = this.getKey();
        if (key != null) {
            return this.getIdx() + " [" + key + "], inlineCacheList=" + this.inlineCacheList;
        }
        return "HotMethodRegion{diffWithLastMethodDexIndex=" + this.diffWithLastMethodDexIndex + ", inlineCacheList=" + this.inlineCacheList + '}';
    }
}

