/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.dexopt.HotMethodRegion;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.SizedBlockList;
import com.reandroid.dex.model.DexFile;
import com.reandroid.json.JSONArray;
import com.reandroid.json.JSONConvert;
import com.reandroid.utils.CompareUtil;
import java.io.IOException;

public class HotMethodRegionList
extends SizedBlockList<HotMethodRegion>
implements LinkableProfileItem,
JSONConvert<JSONArray> {
    public HotMethodRegionList(IntegerReference bytesSize) {
        super(bytesSize, HotMethodRegion.CREATOR);
    }

    public boolean sort() {
        boolean sorted = this.sort(CompareUtil.getComparableComparator());
        this.updateIdx();
        return sorted;
    }

    public void removeInvalids() {
        this.removeIf(HotMethodRegion::isInvalid);
    }

    @Override
    public void link(DexFile dexFile) {
        LinkableProfileItem.linkAll(dexFile, this.iterator());
    }

    @Override
    public void update(DexFile dexFile) {
        LinkableProfileItem.updateAll(dexFile, this.iterator());
        this.removeInvalids();
        this.sort();
    }

    @Override
    protected void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.initIdx();
    }

    @Override
    protected void onRefreshed() {
        super.onRefreshed();
        this.sort();
    }

    private void initIdx() {
        int lastId = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            HotMethodRegion item = (HotMethodRegion)this.get(i);
            int idx = lastId + item.diffWithLastMethodDexIndex().get();
            item.setIdx(idx);
            lastId = idx;
        }
    }

    private void updateIdx() {
        int lastId = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            HotMethodRegion item = (HotMethodRegion)this.get(i);
            int idx = item.getIdx();
            item.diffWithLastMethodDexIndex().set(idx - lastId);
            lastId = idx;
        }
    }

    @Override
    public JSONArray toJson() {
        return BlockList.toJsonArray(this);
    }

    @Override
    public void fromJson(JSONArray json) {
        BlockList.fromJsonArray(this, json);
        this.sort();
    }
}

