/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.BlockList;
import com.reandroid.arsc.container.FixedBlockContainer;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.dexopt.InlineCachePcMap;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.MethodEncodingType;
import com.reandroid.dex.dexopt.SizedBlockList;
import com.reandroid.dex.model.DexFile;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import java.io.IOException;

public class InlineCache
extends FixedBlockContainer
implements LinkableProfileItem,
JSONConvert<JSONObject> {
    private final IntegerReference dexPc = new ShortItem();
    private final IntegerReference dexPcMapSize;
    private final BlockList<InlineCachePcMap> pcMapList;
    public static final Creator<InlineCache> CREATOR = InlineCache::new;

    public InlineCache() {
        super(3);
        final ByteItem dexPcMapSize = new ByteItem();
        this.dexPcMapSize = dexPcMapSize;
        IntegerReference count = new IntegerReference(){

            @Override
            public int get() {
                int i = dexPcMapSize.get();
                if (!MethodEncodingType.isPcMapSize(i)) {
                    i = 0;
                }
                return i;
            }

            @Override
            public void set(int value) {
                dexPcMapSize.set(value);
            }

            public String toString() {
                return Integer.toString(this.get());
            }
        };
        this.pcMapList = new SizedBlockList<InlineCachePcMap>(count, InlineCachePcMap.CREATOR);
        this.addChild(0, (Block)((Object)this.dexPc));
        this.addChild(1, dexPcMapSize);
        this.addChild(2, this.pcMapList);
    }

    public IntegerReference dexPc() {
        return this.dexPc;
    }

    public BlockList<InlineCachePcMap> pcMapList() {
        return this.pcMapList;
    }

    public MethodEncodingType getEncodingType() {
        return MethodEncodingType.valueOf(this.dexPcMapSize.get());
    }

    public void setEncodingType(MethodEncodingType type) {
        if (type != null) {
            this.dexPcMapSize.set(type.flag());
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
    }

    @Override
    public void link(DexFile dexFile) {
        LinkableProfileItem.linkAll(dexFile, this.pcMapList.iterator());
    }

    @Override
    public void update(DexFile dexFile) {
        LinkableProfileItem.updateAll(dexFile, this.pcMapList.iterator());
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("pc", this.dexPc().get());
        MethodEncodingType type = this.getEncodingType();
        if (type != null) {
            jsonObject.put("type", type.name());
        }
        jsonObject.put("pc_maps", BlockList.toJsonArray(this.pcMapList()));
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.dexPc().set(json.getInt("pc"));
        this.setEncodingType(MethodEncodingType.valueOf(json.optString("type")));
        BlockList.fromJsonArray(this.pcMapList(), json.optJSONArray("pc_maps"));
    }

    public String toString() {
        return "InlineCache{dexPc=" + this.dexPc + "type=" + this.getEncodingType() + ", pcMapList=" + this.pcMapList + '}';
    }
}

