/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.dex.dexopt.BooleanBit;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.MethodBitmap;
import com.reandroid.dex.dexopt.MethodEncodingType;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;

public class MethodBitmapElement
implements LinkableProfileItem,
KeyReference,
JSONConvert<JSONObject> {
    private final BooleanBit startup;
    private final BooleanBit postStartup;

    public MethodBitmapElement(BooleanBit startup, BooleanBit postStartup) {
        this.startup = startup;
        this.postStartup = postStartup;
    }

    public int getIdx() {
        return this.startup.getIndex();
    }

    public void setIdx(int idx) {
        if (idx == this.getIdx()) {
            return;
        }
        MethodBitmap bitmap = this.getParentBitmap();
        if (bitmap != null) {
            bitmap.moveTo(this, idx);
        }
    }

    @Override
    public MethodKey getKey() {
        return (MethodKey)this.startup.getTag();
    }

    @Override
    public void setKey(Key key) {
        this.startup.setTag(key);
    }

    public BooleanBit startup() {
        return this.startup;
    }

    public BooleanBit postStartup() {
        return this.postStartup;
    }

    public boolean isStartup() {
        return this.startup.get();
    }

    public void setStartup(boolean value) {
        this.startup.set(value);
    }

    public boolean isPostStartup() {
        return this.postStartup.get();
    }

    public void setPostStartup(boolean value) {
        this.postStartup.set(value);
    }

    public int getFlags() {
        int result = 0;
        if (this.isStartup()) {
            result |= MethodEncodingType.STARTUP.flag();
        }
        if (this.isPostStartup()) {
            result |= MethodEncodingType.POST_STARTUP.flag();
        }
        return result;
    }

    public void removeSelf() {
        MethodBitmap bitmap = this.getParentBitmap();
        if (bitmap != null) {
            bitmap.remove(this);
        }
    }

    public boolean isInvalid() {
        Boolean invalid = (Boolean)this.postStartup.getTag();
        if (invalid != null) {
            return invalid;
        }
        return false;
    }

    private void setInvalid(boolean invalid) {
        this.postStartup.setTag(invalid ? Boolean.TRUE : null);
    }

    private MethodBitmap getParentBitmap() {
        return this.startup.getParentInstance(MethodBitmap.class);
    }

    @Override
    public void link(DexFile dexFile) {
        boolean invalid;
        MethodKey key;
        MethodId methodId = dexFile.getItem(SectionType.METHOD_ID, this.getIdx());
        if (methodId != null) {
            key = methodId.getKey();
            invalid = false;
        } else {
            key = null;
            invalid = true;
        }
        this.setKey(key);
        this.setInvalid(invalid);
    }

    @Override
    public void update(DexFile dexFile) {
        boolean invalid;
        MethodId methodId = dexFile.getItem(SectionType.METHOD_ID, this.getKey());
        if (methodId != null) {
            this.setIdx(methodId.getIdx());
            invalid = false;
        } else {
            invalid = true;
        }
        this.setInvalid(invalid);
    }

    @Override
    public JSONObject toJson() {
        MethodKey key;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", this.getIdx());
        if (this.isStartup()) {
            jsonObject.put("startup", true);
        }
        if (this.isPostStartup()) {
            jsonObject.put("post_startup", true);
        }
        if ((key = this.getKey()) != null) {
            jsonObject.put("key", key.toString());
        }
        if (this.isInvalid()) {
            jsonObject.put("invalid", true);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setKey(MethodKey.parse(json.optString("key")));
        this.setStartup(json.optBoolean("startup", false));
        this.setPostStartup(json.optBoolean("post_startup", false));
        this.setInvalid(json.optBoolean("invalid", false));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        MethodBitmapElement element = (MethodBitmapElement)obj;
        return this.startup == element.startup;
    }

    public int hashCode() {
        return this.getIdx();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isInvalid()) {
            builder.append("INVALID ");
        }
        builder.append(this.getIdx());
        builder.append(" (");
        builder.append(this.isStartup());
        builder.append(", ");
        builder.append(this.isPostStartup());
        builder.append(")");
        MethodKey key = this.getKey();
        if (key != null) {
            builder.append(", ");
            builder.append(key);
        }
        return builder.toString();
    }
}

