/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyReference;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONConvert;
import com.reandroid.json.JSONObject;
import com.reandroid.utils.CompareUtil;

public class ProfileClass
extends ShortItem
implements LinkableProfileItem,
KeyReference,
Comparable<ProfileClass>,
JSONConvert<JSONObject> {
    private int idx = -1;
    private TypeKey typeKey;
    private boolean invalid;
    public static final Creator<ProfileClass> CREATOR = ProfileClass::new;

    @Override
    public TypeKey getKey() {
        return this.typeKey;
    }

    @Override
    public void setKey(Key typeKey) {
        this.typeKey = (TypeKey)typeKey;
    }

    public int getIdx() {
        return this.idx;
    }

    public void setIdx(int idx) {
        this.idx = idx;
    }

    @Override
    public void link(DexFile dexFile) {
        TypeId typeId = dexFile.getItem(SectionType.TYPE_ID, this.getIdx());
        if (typeId != null) {
            this.setKey(typeId.getKey());
            this.invalid = false;
        } else {
            this.invalid = true;
        }
    }

    @Override
    public void update(DexFile dexFile) {
        TypeId typeId = dexFile.getItem(SectionType.TYPE_ID, this.getKey());
        if (typeId != null) {
            this.setIdx(typeId.getIdx());
            this.invalid = false;
        } else {
            this.invalid = true;
        }
    }

    public boolean isInvalid() {
        return this.invalid;
    }

    @Override
    public int compareTo(ProfileClass profileClass) {
        if (profileClass == this) {
            return 0;
        }
        return CompareUtil.compare(this.getIdx(), profileClass.getIdx());
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", this.getIdx());
        TypeKey key = this.getKey();
        if (key != null) {
            jsonObject.put("key", key.getTypeName());
        }
        if (this.isInvalid()) {
            jsonObject.put("invalid", true);
        }
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        this.setIdx(json.optInt("id"));
        this.setKey(TypeKey.create(json.optString("key")));
        this.invalid = json.optBoolean("invalid", false);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.isInvalid()) {
            builder.append("INVALID ");
        }
        builder.append(this.getIdx());
        TypeKey key = this.getKey();
        if (key != null) {
            builder.append(" [");
            builder.append(key);
            builder.append(']');
        }
        return builder.toString();
    }
}

