/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.dexopt.LinkableProfileItem;
import com.reandroid.dex.dexopt.ProfileBody;
import com.reandroid.dex.dexopt.ProfileMetadata;
import com.reandroid.dex.dexopt.ProfileMetadataHeaderV1;
import com.reandroid.dex.dexopt.ProfileMetadataV1;
import com.reandroid.dex.dexopt.ProfileMetadataV2;
import com.reandroid.dex.dexopt.ProfileVersion;
import java.util.Iterator;
import java.util.function.Predicate;

public class ProfileMetadataBody
extends ProfileBody
implements LinkableProfileItem {
    private final CountedBlockList<ProfileMetadataHeaderV1> headerList;
    private final CountedBlockList<ProfileMetadata> dataList;

    public ProfileMetadataBody(final ProfileVersion version, final IntegerReference count, IntegerReference sizeUncompressed, IntegerReference sizeCompressed) {
        super(2, version, sizeUncompressed, sizeCompressed);
        IntegerReference headerCountReference = new IntegerReference(){

            @Override
            public int get() {
                if (version.get() == ProfileVersion.METADATA_V001_N) {
                    return count.get();
                }
                return 0;
            }

            @Override
            public void set(int value) {
                if (version.get() == ProfileVersion.METADATA_V001_N) {
                    count.set(value);
                }
            }

            public String toString() {
                return Integer.toString(this.get());
            }
        };
        this.headerList = new CountedBlockList<ProfileMetadataHeaderV1>(ProfileMetadataHeaderV1.CREATOR, headerCountReference);
        Creator<ProfileMetadata> creator = new Creator<ProfileMetadata>(){

            @Override
            public ProfileMetadata newInstance() {
                if (version.get() == ProfileVersion.METADATA_V001_N) {
                    throw new RuntimeException("Must call newInstanceAt");
                }
                return new ProfileMetadataV2();
            }

            @Override
            public ProfileMetadata newInstanceAt(int index) {
                if (version.get() == ProfileVersion.METADATA_V001_N) {
                    if (ProfileMetadataBody.this.headerList.size() <= index) {
                        ProfileMetadataBody.this.headerList.setSize(index + 1);
                    }
                    return new ProfileMetadataV1((ProfileMetadataHeaderV1)ProfileMetadataBody.this.headerList.get(index));
                }
                return new ProfileMetadataV2();
            }
        };
        this.dataList = new CountedBlockList<ProfileMetadata>(creator, count);
        this.addChild(0, this.headerList);
        this.addChild(1, this.dataList);
    }

    @Override
    public int size() {
        return this.dataList.size();
    }

    @Override
    public void setSize(int size) {
        this.dataList.setSize(size);
    }

    @Override
    public ProfileMetadata get(int i) {
        return (ProfileMetadata)this.dataList.get(i);
    }

    public Iterator<ProfileMetadata> iterator() {
        return this.dataList.iterator();
    }

    @Override
    public boolean removeIfName(Predicate<String> predicate) {
        return this.dataList.removeIf(dexProfileData -> predicate.test(dexProfileData.getName()));
    }

    @Override
    public boolean removeData(int i) {
        return this.dataList.remove(i) != null;
    }
}

