/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.dexopt.ByteOrShortItem;
import com.reandroid.dex.dexopt.ProfileFile;
import com.reandroid.dex.dexopt.ProfileMagic;
import com.reandroid.dex.dexopt.ProfileMetadata;
import com.reandroid.dex.dexopt.ProfileMetadataBody;
import com.reandroid.dex.dexopt.ProfileVersion;
import com.reandroid.utils.ObjectsUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class ProfileMetadataFile
extends ProfileFile {
    public final ProfileMagic magic = new ProfileMagic();
    public final ProfileVersion version;
    public final ProfileMetadataBody body;

    public ProfileMetadataFile() {
        super(6);
        ProfileVersion version;
        this.version = version = new ProfileVersion();
        ByteOrShortItem count = new ByteOrShortItem(this.version().isMetadataV001());
        IntegerItem unCompressedSize = version.newBodySize();
        IntegerItem compressedSize = version.newBodySize();
        this.body = new ProfileMetadataBody(version, count, (IntegerReference)unCompressedSize, (IntegerReference)compressedSize);
        this.addChild(0, this.magic);
        this.addChild(1, version);
        this.addChild(2, count);
        this.addChild(3, unCompressedSize);
        this.addChild(4, compressedSize);
        this.addChild(5, this.body);
        this.magic.set(ProfileMagic.MAGIC_PROFM);
        version.set(ProfileVersion.METADATA_V001_N);
    }

    @Override
    public ProfileMagic magic() {
        return this.magic;
    }

    @Override
    public ProfileVersion version() {
        return this.version;
    }

    @Override
    public ProfileMetadataBody body() {
        return this.body;
    }

    @Override
    public ProfileMetadata get(String name) {
        return (ProfileMetadata)super.get(name);
    }

    public Iterator<ProfileMetadata> iterator() {
        return (Iterator)ObjectsUtil.cast(super.iterator());
    }

    public static ProfileMetadataFile read(File file) throws IOException {
        ProfileMetadataFile profileFile = new ProfileMetadataFile();
        profileFile.readBytes(new BlockReader(file));
        return profileFile;
    }

    public static ProfileMetadataFile read(InputStream inputStream) throws IOException {
        ProfileMetadataFile profileFile = new ProfileMetadataFile();
        profileFile.readBytes(new BlockReader(inputStream));
        return profileFile;
    }
}

