/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.dexopt;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.arsc.item.StringReference;
import com.reandroid.dex.dexopt.ProfString;
import com.reandroid.dex.dexopt.ProfileClassList;
import com.reandroid.dex.dexopt.ProfileMetadata;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.json.JSONObject;

public class ProfileMetadataV2
extends ProfileMetadata {
    private final IntegerReference profileIndex = new ShortItem();
    private final StringReference name;
    private final IntegerReference typeIdCount;
    private final ProfileClassList classList;

    public ProfileMetadataV2() {
        super(6);
        ShortItem dexNameSize = new ShortItem();
        this.name = new ProfString(dexNameSize);
        this.typeIdCount = new IntegerItem();
        ShortItem classSetSize = new ShortItem();
        this.classList = new ProfileClassList(classSetSize);
        this.addChild(0, (Block)((Object)this.profileIndex));
        this.addChild(1, dexNameSize);
        this.addChild(2, (Block)((Object)this.name));
        this.addChild(3, (Block)((Object)this.typeIdCount));
        this.addChild(4, classSetSize);
        this.addChild(5, this.classList);
    }

    public IntegerReference profileIndex() {
        return this.profileIndex;
    }

    public IntegerReference typeIdCount() {
        return this.typeIdCount;
    }

    @Override
    public ProfileClassList classList() {
        return this.classList;
    }

    @Override
    public StringReference name() {
        return this.name;
    }

    @Override
    public void update(DexFile dexFile) {
        if (!this.isInitialized()) {
            this.profileIndex().set(this.getIndex());
        }
        this.typeIdCount().set(dexFile.getCount(SectionType.TYPE_ID));
        super.update(dexFile);
    }

    @Override
    public JSONObject toJson() {
        JSONObject jsonObject = super.toJson();
        jsonObject.put("profile_index", this.profileIndex().get());
        jsonObject.put("types", this.typeIdCount().get());
        return jsonObject;
    }

    @Override
    public void fromJson(JSONObject json) {
        super.fromJson(json);
        this.profileIndex().set(json.getInt("profile_index"));
        this.typeIdCount().set(json.getInt("types"));
    }

    @Override
    public String toString() {
        return super.toString() + ", profileIndex=" + this.profileIndex() + ", types=" + this.typeIdCount();
    }
}

