/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.header;

import com.reandroid.dex.header.HeaderPiece;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.utils.Alder32OutputStream;
import com.reandroid.utils.HexUtil;
import java.io.IOException;
import java.io.OutputStream;

public class DexChecksum
extends HeaderPiece {
    public DexChecksum() {
        super(4);
    }

    public int getValue() {
        return this.getInteger(0);
    }

    public void setValue(long checksum) {
        this.setSize(4);
        this.putInteger(0, (int)checksum);
    }

    public boolean update() {
        DexLayoutBlock dexLayoutBlock = this.getParentInstance(DexLayoutBlock.class);
        if (dexLayoutBlock == null) {
            return false;
        }
        int previous = this.getValue();
        Alder32OutputStream outputStream = new Alder32OutputStream();
        try {
            dexLayoutBlock.writeBytes(outputStream);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        this.setValue(outputStream.getValue());
        return previous != this.getValue();
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        if (stream instanceof Alder32OutputStream) {
            ((Alder32OutputStream)stream).reset();
            return 0;
        }
        return super.onWriteBytes(stream);
    }

    @Override
    public String toString() {
        return HexUtil.toHex8(this.getValue());
    }
}

