/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.header;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.ByteArray;
import com.reandroid.dex.header.HeaderPiece;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class Magic
extends HeaderPiece {
    private boolean disableVerification;
    public static final byte[] DEFAULT_BYTES = new byte[]{100, 101, 120, 10};

    public Magic() {
        super.set((byte[])DEFAULT_BYTES.clone());
    }

    public void reset() {
        super.set((byte[])DEFAULT_BYTES.clone());
    }

    public boolean isValid() {
        return ByteArray.equals(this.getBytesInternal(), DEFAULT_BYTES);
    }

    public boolean isDisableVerification() {
        return this.disableVerification;
    }

    public void setDisableVerification(boolean disableVerification) {
        this.disableVerification = disableVerification;
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        if (!this.isDisableVerification() && !this.isValid()) {
            throw new IOException("Invalid dex magic: '" + HexUtil.toHexString(this.getBytesInternal()) + "', expecting '" + HexUtil.toHexString(DEFAULT_BYTES) + "'");
        }
    }
}

