/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.header;

import com.reandroid.dex.header.HeaderPiece;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.Sha1OutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class Signature
extends HeaderPiece {
    public Signature() {
        super(20);
    }

    public void update() {
        DexLayoutBlock dexLayoutBlock = this.getParentInstance(DexLayoutBlock.class);
        if (dexLayoutBlock == null) {
            return;
        }
        Sha1OutputStream outputStream = new Sha1OutputStream();
        try {
            dexLayoutBlock.writeBytes(outputStream);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        outputStream.digest(this.getBytesInternal(), 0);
    }

    @Override
    protected int onWriteBytes(OutputStream stream) throws IOException {
        if (stream instanceof Sha1OutputStream) {
            ((Sha1OutputStream)stream).reset();
            return 0;
        }
        return super.onWriteBytes(stream);
    }

    public String getHex() {
        return HexUtil.toHexString(this.getBytesInternal());
    }

    @Override
    public String toString() {
        return this.getHex();
    }
}

