/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.id;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IndirectInteger;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.IdDefinition;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.dalvik.DalvikEnclosing;
import com.reandroid.dex.dalvik.DalvikMemberClass;
import com.reandroid.dex.data.AnnotationsDirectory;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.Def;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.data.TypeList;
import com.reandroid.dex.id.ClassTypeId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.id.SourceFile;
import com.reandroid.dex.id.SuperClassId;
import com.reandroid.dex.id.TypeId;
import com.reandroid.dex.key.AnnotationSetKey;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.program.ClassProgram;
import com.reandroid.dex.reference.DataItemIndirectReference;
import com.reandroid.dex.reference.TypeListReference;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;

public class ClassId
extends IdItem
implements ClassProgram,
IdDefinition<TypeId>,
Comparable<ClassId> {
    private final ClassTypeId classTypeId;
    private final IndirectInteger accessFlagValue;
    private final SuperClassId superClassId;
    private final TypeListReference interfaces;
    private final SourceFile sourceFile;
    private final DataItemIndirectReference<AnnotationsDirectory> annotationsDirectory;
    private final DataItemIndirectReference<ClassData> classData;
    private final DataItemIndirectReference<EncodedArray> staticValues;
    private static final int SIZE = 32;

    public ClassId() {
        super(32);
        int offset = -4;
        this.classTypeId = new ClassTypeId(this, offset += 4);
        this.accessFlagValue = new IndirectInteger(this, offset += 4);
        this.superClassId = new SuperClassId(this, offset += 4);
        this.interfaces = new TypeListReference(this, offset += 4, USAGE_INTERFACE);
        this.sourceFile = new SourceFile(this, offset += 4);
        this.annotationsDirectory = new DataItemIndirectReference<AnnotationsDirectory>(SectionType.ANNOTATION_DIRECTORY, this, offset += 4, UsageMarker.USAGE_DEFINITION);
        this.classData = new DataItemIndirectReference<ClassData>(SectionType.CLASS_DATA, this, offset += 4, UsageMarker.USAGE_DEFINITION);
        this.staticValues = new DataItemIndirectReference<EncodedArray>(SectionType.ENCODED_ARRAY, this, offset += 4, UsageMarker.USAGE_STATIC_VALUES);
        this.addUsageType(UsageMarker.USAGE_DEFINITION);
    }

    @Override
    public void clearUsageType() {
    }

    @Override
    public void edit() {
        this.editInternal(this);
    }

    @Override
    public void editInternal(Block user) {
        this.annotationsDirectory.editInternal(this);
        this.classData.editInternal(this);
        this.staticValues.editInternal(this);
    }

    public SectionType<ClassId> getSectionType() {
        return SectionType.CLASS_ID;
    }

    @Override
    public TypeKey getKey() {
        return this.checkKey(TypeKey.create(this.getName()));
    }

    @Override
    public void setKey(Key key) {
        TypeKey old = this.getKey();
        if (Objects.equals(old, key)) {
            return;
        }
        this.classTypeId.setKey(key);
        this.keyChanged(old);
    }

    @Override
    public AnnotationSetKey getAnnotation() {
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            return directory.getClassAnnotation();
        }
        return AnnotationSetKey.empty();
    }

    @Override
    public void setAnnotation(AnnotationSetKey annotationSet) {
        this.clearAnnotations();
        this.writeAnnotation(annotationSet);
    }

    @Override
    public void clearAnnotations() {
        this.writeAnnotation(AnnotationSetKey.empty());
    }

    @Override
    public boolean hasAnnotations() {
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            return directory.hasClassAnnotation();
        }
        return false;
    }

    private void writeAnnotation(AnnotationSetKey key) {
        if (key == null || key.isEmpty()) {
            if (this.hasAnnotations()) {
                this.getOrCreateUniqueAnnotationsDirectory().setClassAnnotations((AnnotationSetKey)null);
            }
        } else {
            this.getOrCreateUniqueAnnotationsDirectory().setClassAnnotations(key);
        }
    }

    public String getName() {
        TypeId typeId = this.getId();
        if (typeId != null) {
            return typeId.getName();
        }
        return null;
    }

    public void setName(String typeName) {
        this.setKey(new TypeKey(typeName));
    }

    public ClassTypeId getClassTypeId() {
        return this.classTypeId;
    }

    @Override
    public TypeId getId() {
        return (TypeId)this.getClassTypeId().getItem();
    }

    @Override
    public int getAccessFlagsValue() {
        return this.accessFlagValue.get();
    }

    @Override
    public void setAccessFlagsValue(int value) {
        this.accessFlagValue.set(value);
    }

    public void setId(TypeId typeId) {
        this.classTypeId.setItem(typeId);
    }

    public SuperClassId getSuperClassId() {
        return this.superClassId;
    }

    public TypeId getSuperClassType() {
        return (TypeId)this.getSuperClassId().getItem();
    }

    @Override
    public TypeKey getSuperClassKey() {
        return this.getSuperClassId().getKey();
    }

    public void setSuperClass(TypeKey typeKey) {
        this.superClassId.setKey(typeKey);
    }

    public SourceFile getSourceFileReference() {
        return this.sourceFile;
    }

    @Override
    public String getSourceFileName() {
        return this.getSourceFileReference().getString();
    }

    public void setSourceFile(String sourceFile) {
        this.getSourceFileReference().setString(sourceFile);
    }

    public Iterator<TypeKey> getInstanceKeys() {
        return CombiningIterator.singleOne(this.getSuperClassKey(), this.getInterfacesKey().iterator());
    }

    @Override
    public TypeListKey getInterfacesKey() {
        TypeListKey typeListKey = this.interfaces.getKey();
        if (typeListKey == null) {
            typeListKey = TypeListKey.empty();
        }
        return typeListKey;
    }

    public TypeList getInterfaceTypeList() {
        return (TypeList)this.interfaces.getItem();
    }

    public TypeListReference getInterfacesReference() {
        return this.interfaces;
    }

    public void setInterfaces(TypeListKey typeListKey) {
        this.interfaces.setKey(typeListKey);
    }

    public Iterator<FieldDef> getStaticFields() {
        ClassData classData = this.getClassData();
        if (classData != null) {
            return classData.getStaticFields();
        }
        return EmptyIterator.of();
    }

    public Iterator<FieldDef> getInstanceFields() {
        ClassData classData = this.getClassData();
        if (classData != null) {
            return classData.getInstanceFields();
        }
        return EmptyIterator.of();
    }

    public Iterator<MethodDef> getDirectMethods() {
        ClassData classData = this.getClassData();
        if (classData != null) {
            return classData.getDirectMethods();
        }
        return EmptyIterator.of();
    }

    public Iterator<MethodDef> getVirtualMethods() {
        ClassData classData = this.getClassData();
        if (classData != null) {
            return classData.getVirtualMethods();
        }
        return EmptyIterator.of();
    }

    public TypeKey getDalvikEnclosing() {
        DalvikEnclosing<?> enclosing = DalvikEnclosing.of(this);
        if (enclosing != null) {
            return enclosing.getEnclosingClass();
        }
        return null;
    }

    public Iterator<TypeKey> getDalvikMemberClasses() {
        DalvikMemberClass dalvikMemberClass = DalvikMemberClass.of(this);
        if (dalvikMemberClass != null) {
            return dalvikMemberClass.getMembers();
        }
        return EmptyIterator.of();
    }

    public AnnotationsDirectory getUniqueAnnotationsDirectory() {
        return this.annotationsDirectory.getUniqueItem(this);
    }

    public AnnotationsDirectory getOrCreateUniqueAnnotationsDirectory() {
        return this.annotationsDirectory.getOrCreateUniqueItem(this);
    }

    public AnnotationsDirectory getAnnotationsDirectory() {
        return (AnnotationsDirectory)this.annotationsDirectory.getItem();
    }

    public void setAnnotationsDirectory(AnnotationsDirectory directory) {
        this.annotationsDirectory.setItem(directory);
    }

    public ClassData getOrCreateClassData() {
        ClassData classData = this.getClassData();
        if (classData != null) {
            return classData;
        }
        Section<ClassData> section = this.getSection(SectionType.CLASS_DATA);
        classData = section.createItem();
        this.setClassData(classData);
        return classData;
    }

    public Def<?> getDef(Key key) {
        ClassData classData = this.getClassData();
        if (classData != null) {
            return classData.get(key);
        }
        return null;
    }

    public ClassData getClassData() {
        ClassData data = (ClassData)this.classData.getItem();
        this.linkClassData(data);
        return data;
    }

    public void setClassData(ClassData classData) {
        this.classData.setItem(classData);
        this.linkClassData(classData);
    }

    public EncodedArray getStaticValuesEncodedArray() {
        EncodedArray encodedArray = (EncodedArray)this.staticValues.getItem();
        if (encodedArray != null) {
            encodedArray.addUniqueUser(this);
        }
        return encodedArray;
    }

    public ArrayValueKey getStaticValues() {
        return (ArrayValueKey)this.staticValues.getKey();
    }

    public void setStaticValues(ArrayValueKey staticValues) {
        this.staticValues.setKey(staticValues);
        this.staticValues.addUniqueUser(this);
    }

    public void setStaticValues(EncodedArray staticValues) {
        this.staticValues.setItem(staticValues);
    }

    @Override
    public void refresh() {
        this.annotationsDirectory.addUniqueUser(this);
        this.classData.addUniqueUser(this);
        this.staticValues.addUniqueUser(this);
        this.classTypeId.refresh();
        this.superClassId.refresh();
        this.interfaces.refresh();
        this.sourceFile.refresh();
        this.annotationsDirectory.refresh();
        this.classData.refresh();
        this.staticValues.refresh();
    }

    @Override
    void cacheItems() {
        this.classTypeId.pullItem();
        this.superClassId.pullItem();
        this.interfaces.pullItem();
        this.sourceFile.pullItem();
        this.annotationsDirectory.pullItem();
        this.classData.pullItem();
        this.staticValues.pullItem();
        this.annotationsDirectory.addUniqueUser(this);
        this.classData.addUniqueUser(this);
        this.staticValues.addUniqueUser(this);
        this.linkClassData((ClassData)this.classData.getItem());
    }

    private void linkClassData(ClassData classData) {
        if (classData != null) {
            classData.setClassId(this);
        }
    }

    @Override
    public void removeSelf() {
        super.removeSelf();
        this.classTypeId.unlink();
        this.superClassId.unlink();
        this.sourceFile.unlink();
        this.classData.unlink();
        this.annotationsDirectory.unlink();
        this.staticValues.unlink();
    }

    @Override
    public boolean isRemoved() {
        return super.isRemoved();
    }

    public void replaceKeys(Key search, Key replace) {
        this.classTypeId.replaceKeys(search, replace);
        this.superClassId.replaceKeys(search, replace);
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            directory = this.getUniqueAnnotationsDirectory();
            directory.replaceKeys(search, replace);
        }
        this.interfaces.replaceKeys(search, replace);
        ClassData classData = this.getClassData();
        if (classData != null) {
            classData.replaceKeys(search, replace);
        }
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return this.listUsedIds().iterator();
    }

    public ArrayCollection<IdItem> listUsedIds() {
        EncodedArray encodedArray;
        ClassData classData;
        ArrayCollection<IdItem> collection = new ArrayCollection<IdItem>(200);
        collection.add((IdItem)this.classTypeId.getItem());
        collection.add((IdItem)this.superClassId.getItem());
        collection.add((IdItem)this.sourceFile.getItem());
        collection.addAll(this.interfaces.iterator());
        AnnotationsDirectory directory = this.getAnnotationsDirectory();
        if (directory != null) {
            collection.addAll(directory.usedIds());
        }
        if ((classData = this.getClassData()) != null) {
            collection.addAll(classData.usedIds());
        }
        if ((encodedArray = this.getStaticValuesEncodedArray()) != null) {
            collection.addAll(encodedArray.usedIds());
        }
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            IdItem idItem = collection.get(i);
            collection.addAll(idItem.usedIds());
        }
        return collection;
    }

    public void merge(ClassId classId) {
        ClassData comingData;
        if (classId == this) {
            return;
        }
        this.accessFlagValue.set(classId.accessFlagValue.get());
        this.superClassId.setKey(classId.superClassId.getKey());
        this.sourceFile.setKey(classId.sourceFile.getKey());
        this.interfaces.setKey(classId.interfaces.getKey());
        this.annotationsDirectory.setKey(classId.annotationsDirectory.getKey());
        EncodedArray comingArray = classId.getStaticValuesEncodedArray();
        if (comingArray != null) {
            EncodedArray encodedArray = this.staticValues.getOrCreate();
            encodedArray.merge(comingArray);
        }
        if ((comingData = classId.getClassData()) != null) {
            ClassData classData = this.getOrCreateClassData();
            classData.merge(comingData);
        }
    }

    public void fromSmali(SmaliClass smaliClass) throws IOException {
        this.setKey(smaliClass.getKey());
        this.setAccessFlagsValue(smaliClass.getAccessFlagsValue());
        this.setSuperClass(smaliClass.getSuperClassKey());
        this.setSourceFile(smaliClass.getSourceFileName());
        this.setInterfaces(smaliClass.getInterfacesKey());
        if (smaliClass.hasClassData()) {
            this.getOrCreateClassData().fromSmali(smaliClass);
        }
        if (smaliClass.hasAnnotation()) {
            this.setAnnotation(smaliClass.getAnnotationSetKey());
        }
    }

    public SmaliClass toSmali() {
        SmaliClass smaliClass = new SmaliClass();
        smaliClass.setKey(this.getKey());
        smaliClass.setAccessFlags(InstanceIterator.of(this.getAccessFlags(), AccessFlag.class));
        smaliClass.setSuperClass(this.getSuperClassKey());
        smaliClass.setSourceFile(this.getSourceFileReference().getKey());
        smaliClass.setInterfaces(this.getInterfacesReference().getKey());
        smaliClass.setAnnotation(this.getAnnotation());
        ClassData classData = this.getClassData();
        if (classData != null) {
            classData.toSmali(smaliClass);
        }
        return smaliClass;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getClassTypeId().append(writer);
        this.getSuperClassId().append(writer);
        this.getSourceFileReference().append(writer);
        this.getInterfacesKey().appendInterfaces(writer);
        this.getAnnotation().appendClass(writer);
        ClassData classData = this.getClassData();
        if (classData != null) {
            writer.newLine();
            classData.append(writer);
        }
    }

    @Override
    public int compareTo(ClassId classId) {
        if (classId == null) {
            return -1;
        }
        if (classId == this) {
            return 0;
        }
        return SectionTool.compareIdx(this.getId(), classId.getId());
    }

    public String toString() {
        if (this.isReading()) {
            return ".class " + this.getKey();
        }
        return SmaliWriter.toStringSafe(this);
    }
}

