/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.NumberBlock;
import com.reandroid.dex.ins.InsArrayData;
import com.reandroid.dex.ins.PayloadEntry;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValueX;
import java.io.IOException;

public class ArrayDataEntry
extends NumberBlock
implements PayloadEntry {
    public ArrayDataEntry(int width) {
        super(width);
    }

    public void fromSmali(SmaliValueX smaliValueX) {
        this.set(smaliValueX.getValueAsLong());
    }

    public SmaliValueX toSmali() {
        return new SmaliValueX(this.width(), this.getLong());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.append(null, writer);
    }

    public void append(TypeKey arrayType, SmaliWriter writer) throws IOException {
        writer.appendHex(this.width(), this.getLong());
        this.appendFloatOrDoubleComment(arrayType, writer);
    }

    private void appendFloatOrDoubleComment(TypeKey arrayType, SmaliWriter writer) {
        if (arrayType == null || !writer.isEnableComments()) {
            return;
        }
        long data = this.getLong();
        if (data == 0L) {
            return;
        }
        TypeKey typeKey = arrayType.setArrayDimension(0);
        if (TypeKey.TYPE_F.equals(typeKey)) {
            float f = Float.intBitsToFloat((int)data);
            writer.appendComment(f + "f");
        } else if (TypeKey.TYPE_D.equals(typeKey)) {
            double d = Double.longBitsToDouble(data);
            writer.appendComment(Double.toString(d));
        } else if (TypeKey.TYPE_C.equals(typeKey)) {
            char c = (char)data;
            writer.appendComment("'" + c + "'");
        }
    }

    public void merge(ArrayDataEntry entry) {
        this.set(entry.getLong());
    }

    public int hashCode() {
        return Block.hashCodeOf(this.getBytesInternal());
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        ArrayDataEntry other = (ArrayDataEntry)obj;
        return Block.areEqual(this.getBytesInternal(), other.getBytesInternal());
    }

    public InsArrayData getPayload() {
        return this.getParentInstance(InsArrayData.class);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        String hex = this.toHexString();
        builder.append(hex);
        int width = this.width();
        if (width == 1) {
            builder.append('t');
        } else if (width == 2) {
            builder.append('S');
        } else if (width == 8 && (this.getLong() & Integer.MIN_VALUE) != 0L) {
            builder.append('L');
        }
        return builder.toString();
    }

    public static Creator<ArrayDataEntry> newCreator(IntegerReference width) {
        return () -> new ArrayDataEntry(width.get());
    }
}

