/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.BlockItem;
import com.reandroid.dex.ins.HandlerOffsetArray;
import com.reandroid.dex.ins.TryItem;
import com.reandroid.utils.CompareUtil;

public class HandlerOffset
extends BlockItem
implements Comparable<HandlerOffset> {
    private TryItem mTryItem;

    HandlerOffset() {
        super(8);
    }

    public int getIdx() {
        TryItem tryItem = this.getTryItem();
        if (tryItem != null) {
            return tryItem.getIndex();
        }
        return this.getIndex();
    }

    public int getStartAddress() {
        return Block.getInteger(this.getBytesInternal(), 0);
    }

    public void setStartAddress(int value) {
        Block.putInteger(this.getBytesInternal(), 0, value);
    }

    public int getCatchCodeUnit() {
        return Block.getShortUnsigned(this.getBytesInternal(), 4);
    }

    public void setCatchCodeUnit(int value) {
        Block.putShort(this.getBytesInternal(), 4, value);
    }

    public int getOffset() {
        return Block.getShortUnsigned(this.getBytesInternal(), 6);
    }

    public void setOffset(int value) {
        Block.putShort(this.getBytesInternal(), 6, value);
    }

    TryItem getTryItem() {
        return this.mTryItem;
    }

    void setTryItem(TryItem tryItem) {
        this.mTryItem = tryItem;
    }

    void removeSelf() {
        this.mTryItem = null;
        HandlerOffsetArray offsetArray = this.getParentInstance(HandlerOffsetArray.class);
        if (offsetArray != null) {
            offsetArray.remove(this);
        }
    }

    @Override
    public int compareTo(HandlerOffset handlerOffset) {
        if (handlerOffset == null) {
            return 0;
        }
        TryItem tryItem = this.getTryItem();
        if (tryItem == null) {
            throw new NullPointerException("Unlinked handler offset: " + this.toString());
        }
        TryItem other = handlerOffset.getTryItem();
        if (other == null) {
            throw new NullPointerException("Unlinked handler offset: " + handlerOffset.toString());
        }
        return CompareUtil.compare(tryItem.getIndex(), other.getIndex());
    }

    public void merge(HandlerOffset handlerOffset) {
        this.setBytes(handlerOffset);
    }

    public String toString() {
        return "(" + this.getIndex() + " : start=" + this.getStartAddress() + ", catch=" + this.getCatchCodeUnit() + ", offset=" + this.getOffset() + ")";
    }
}

