/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.ins.ArrayDataEntry;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Ins22c;
import com.reandroid.dex.ins.InsArrayDataList;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsFillArrayData;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PayloadData;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliPayloadArray;
import com.reandroid.utils.NumberX;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.InstanceIterator;
import java.io.IOException;
import java.util.Iterator;

public class InsArrayData
extends PayloadData<ArrayDataEntry>
implements SmaliRegion {
    private final InsArrayDataList entryList;

    public InsArrayData() {
        super(4, Opcode.ARRAY_PAYLOAD);
        ShortItem widthReference = new ShortItem();
        IntegerItem countReference = new IntegerItem();
        this.entryList = new InsArrayDataList(widthReference, (IntegerReference)countReference);
        this.addChild(1, widthReference);
        this.addChild(2, countReference);
        this.addChild(3, this.entryList);
        this.addChild(4, this.entryList.getAlignment());
    }

    public Iterator<InsFillArrayData> getInsFillArrayData() {
        InsBlockList insBlockList = this.getInsBlockList();
        if (insBlockList == null) {
            return EmptyIterator.of();
        }
        insBlockList.link();
        return InstanceIterator.of(this.getExtraLines(), InsFillArrayData.class);
    }

    @Override
    public int size() {
        return this.getEntryList().size();
    }

    @Override
    public void setSize(int size) {
        if (this.getWidth() == 0) {
            size = 0;
        }
        Object lock = this.requestLock();
        this.getEntryList().setSize(size);
        this.releaseLock(lock);
    }

    public void ensureMinWidth(int width) {
        if (width > this.getWidth()) {
            this.setWidth(NumberX.toStandardWidth(width));
        }
    }

    public void ensureMinSize(int size) {
        if (size > this.size()) {
            this.setSize(size);
        }
    }

    public void clear() {
        Object lock = this.requestLock();
        this.getEntryList().clear();
        this.releaseLock(lock);
    }

    @Override
    public ArrayDataEntry get(int i) {
        return (ArrayDataEntry)this.getEntryList().get(i);
    }

    @Override
    public Iterator<ArrayDataEntry> iterator() {
        return (Iterator)ObjectsUtil.cast(this.getEntryList().clonedIterator());
    }

    public int getWidth() {
        return this.getEntryList().getWidth();
    }

    public void setWidth(int width) {
        Object lock = this.requestLock();
        this.getEntryList().setWidth(width);
        this.releaseLock(lock);
    }

    public void put(int index, long value) {
        this.ensureMinSize(index + 1);
        this.get(index).set(value);
    }

    public void addValue(long value) {
        int index = this.size();
        this.setSize(index + 1);
        this.get(index).set(value);
    }

    public void addValues(long[] values) {
        int start = this.size();
        int length = values.length;
        this.setSize(start + length);
        for (int i = 0; i < length; ++i) {
            this.get(start + i).set(values[i]);
        }
    }

    public void addValues(int[] values) {
        int start = this.size();
        int length = values.length;
        this.setSize(start + length);
        for (int i = 0; i < length; ++i) {
            this.get(start + i).set(values[i]);
        }
    }

    public void addValues(short[] values) {
        int start = this.size();
        int length = values.length;
        this.setSize(start + length);
        for (int i = 0; i < length; ++i) {
            this.get(start + i).set(values[i]);
        }
    }

    public void addValues(byte[] values) {
        int start = this.size();
        int length = values.length;
        this.setSize(start + length);
        for (int i = 0; i < length; ++i) {
            this.get(start + i).set(values[i]);
        }
    }

    public void addValues(char[] values) {
        int start = this.size();
        int length = values.length;
        this.setSize(start + length);
        for (int i = 0; i < length; ++i) {
            this.get(start + i).set(values[i]);
        }
    }

    public void addValues(float[] values) {
        int start = this.size();
        int length = values.length;
        if (length != 0) {
            this.ensureMinWidth(4);
        }
        this.setSize(start + length);
        for (int i = 0; i < length; ++i) {
            this.get(start + i).set(Float.floatToIntBits(values[i]));
        }
    }

    public void addValues(double[] values) {
        int start = this.size();
        int length = values.length;
        if (length != 0) {
            this.ensureMinWidth(8);
        }
        this.setSize(start + length);
        for (int i = 0; i < length; ++i) {
            this.get(start + i).set(Double.doubleToLongBits(values[i]));
        }
    }

    public long[] getValuesAsLong() {
        return this.getEntryList().getValues();
    }

    public int[] getValuesAsInt() {
        return this.getEntryList().getValuesAsInt();
    }

    public short[] getValuesAsShort() {
        return this.getEntryList().getValuesAsShort();
    }

    public byte[] getValuesAsByte() {
        return this.getEntryList().getValuesAsByte();
    }

    public char[] getValuesAsChar() {
        return this.getEntryList().getValuesAsChar();
    }

    public float[] getValuesAsFloat() {
        return this.getEntryList().getValuesAsFloat();
    }

    public double[] getValuesAsDouble() {
        return this.getEntryList().getValuesAsDouble();
    }

    @Override
    public Iterator<IntegerReference> getReferences() {
        return (Iterator)ObjectsUtil.cast(this.getEntryList().iterator());
    }

    InsArrayDataList getEntryList() {
        return this.entryList;
    }

    private TypeKey findNewArrayType() {
        Iterator<InsFillArrayData> iterator = this.getInsFillArrayData();
        while (iterator.hasNext()) {
            InsFillArrayData fillArrayData = iterator.next();
            Ins22c ins22c = fillArrayData.findNewArrayLazy();
            if (ins22c == null) continue;
            return (TypeKey)ins22c.getKey();
        }
        return null;
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.appendInteger(this.getWidth());
        writer.indentPlus();
        this.getEntryList().append(this.findNewArrayType(), writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public void merge(Ins ins) {
        InsArrayData coming = (InsArrayData)ins;
        this.getEntryList().merge(coming.getEntryList());
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.ARRAY_DATA;
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        this.validateOpcode(smaliInstruction);
        this.getEntryList().fromSmali((SmaliPayloadArray)smaliInstruction);
    }

    @Override
    void toSmaliOperand(SmaliInstruction instruction) {
        super.toSmaliOperand(instruction);
        SmaliInstructionOperand.SmaliDecimalOperand operand = (SmaliInstructionOperand.SmaliDecimalOperand)instruction.getOperand();
        operand.setNumber(this.getWidth());
    }

    @Override
    void toSmaliEntries(SmaliInstruction instruction) {
        super.toSmaliEntries(instruction);
        this.getEntryList().toSmali((SmaliPayloadArray)instruction);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        InsArrayData arrayData = (InsArrayData)obj;
        if (this.getIndex() != arrayData.getIndex()) {
            return false;
        }
        if (this.getWidth() != arrayData.getWidth()) {
            return false;
        }
        return this.entryList.equals(arrayData.entryList);
    }

    @Override
    public int hashCode() {
        int hash = 31 + this.getIndex() * 31 + this.getWidth() * 31;
        return hash + this.entryList.hashCode() * 31;
    }
}

