/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.DexBlockAlign;
import com.reandroid.dex.ins.ArrayDataEntry;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliPayloadArray;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.dex.smali.model.SmaliValueX;
import com.reandroid.utils.StringsUtil;
import java.io.IOException;
import java.util.Iterator;

class InsArrayDataList
extends CountedBlockList<ArrayDataEntry> {
    private final IntegerReference widthReference;
    private final DexBlockAlign alignment;

    public InsArrayDataList(IntegerReference widthReference, IntegerReference countReference) {
        super(ArrayDataEntry.newCreator(widthReference), InsArrayDataList.widthCheckingReference(widthReference, countReference));
        this.widthReference = widthReference;
        this.alignment = new DexBlockAlign(this);
        this.alignment.setAlignment(2);
    }

    public DexBlockAlign getAlignment() {
        return this.alignment;
    }

    @Override
    public void setSize(int size) {
        super.setSize(size);
        IntegerReference countReference = this.getCountReference();
        if (size != countReference.get()) {
            countReference.set(size);
        }
        this.getAlignment().align();
    }

    public int getWidth() {
        return this.widthReference.get();
    }

    public void setWidth(int width) {
        this.widthReference.set(width);
        if (width == 0) {
            this.clear();
        } else {
            int size = this.size();
            for (int i = 0; i < size; ++i) {
                ((ArrayDataEntry)this.get(i)).width(width);
            }
            this.getAlignment().align();
        }
    }

    public long[] getValues() {
        int size = this.size();
        long[] results = new long[size];
        for (int i = 0; i < size; ++i) {
            results[i] = ((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public int[] getValuesAsInt() {
        int size = this.size();
        int[] results = new int[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (int)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public short[] getValuesAsShort() {
        int size = this.size();
        short[] results = new short[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (short)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public byte[] getValuesAsByte() {
        int size = this.size();
        byte[] results = new byte[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (byte)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public char[] getValuesAsChar() {
        int size = this.size();
        char[] results = new char[size];
        for (int i = 0; i < size; ++i) {
            results[i] = (char)((ArrayDataEntry)this.get(i)).getLong();
        }
        return results;
    }

    public float[] getValuesAsFloat() {
        int size = this.size();
        float[] results = new float[size];
        for (int i = 0; i < size; ++i) {
            results[i] = Float.intBitsToFloat(((ArrayDataEntry)this.get(i)).get());
        }
        return results;
    }

    public double[] getValuesAsDouble() {
        int size = this.size();
        double[] results = new double[size];
        for (int i = 0; i < size; ++i) {
            results[i] = Double.longBitsToDouble(((ArrayDataEntry)this.get(i)).getLong());
        }
        return results;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public void clear() {
        this.setSize(0);
    }

    public void fromSmali(SmaliPayloadArray smaliPayloadArray) {
        this.setWidth(smaliPayloadArray.getWidth());
        SmaliSet entries = smaliPayloadArray.getEntries();
        int size = entries.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((ArrayDataEntry)this.get(i)).fromSmali((SmaliValueX)entries.get(i));
        }
    }

    public void toSmali(SmaliPayloadArray smaliPayloadArray) {
        int size = this.size();
        smaliPayloadArray.setWidth(this.getWidth());
        for (int i = 0; i < size; ++i) {
            smaliPayloadArray.addEntry(((ArrayDataEntry)this.get(i)).toSmali());
        }
    }

    public void append(TypeKey arrayType, SmaliWriter writer) throws IOException {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ArrayDataEntry entry = (ArrayDataEntry)iterator.next();
            writer.newLine();
            entry.append(arrayType, writer);
        }
    }

    public void merge(InsArrayDataList dataList) {
        this.setWidth(dataList.getWidth());
        int size = dataList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((ArrayDataEntry)this.get(i)).merge((ArrayDataEntry)dataList.get(i));
        }
    }

    @Override
    public String toString() {
        return "width = " + this.getWidth() + ", size = " + this.size() + "\n  " + StringsUtil.join(this.iterator(), (Object)"\n  ");
    }

    private static IntegerReference widthCheckingReference(final IntegerReference width, final IntegerReference reference) {
        return new IntegerReference(){

            @Override
            public int get() {
                if (width.get() == 0) {
                    return 0;
                }
                return reference.get();
            }

            @Override
            public void set(int value) {
                reference.set(value);
            }

            public String toString() {
                return Integer.toString(this.get());
            }
        };
    }
}

