/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.InsSparseSwitch;
import com.reandroid.dex.ins.InsSparseSwitchData;
import com.reandroid.dex.ins.InsSwitchPayload;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PackedSwitchDataList;
import com.reandroid.dex.ins.PackedSwitchEntry;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliInstructionOperand;
import com.reandroid.dex.smali.model.SmaliPayloadPackedSwitch;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;
import java.util.Iterator;

public class InsPackedSwitchData
extends InsSwitchPayload<PackedSwitchEntry> {
    private final IntegerItem firstKey;
    private final PackedSwitchDataList elements;
    private InsSparseSwitchData mReplacement;
    public static final Creator<PackedSwitchEntry> CREATOR = PackedSwitchEntry::new;

    public InsPackedSwitchData() {
        super(3, Opcode.PACKED_SWITCH_PAYLOAD);
        ShortItem elementCount = new ShortItem();
        this.firstKey = new IntegerItem();
        this.elements = new PackedSwitchDataList(this, (IntegerReference)elementCount);
        this.addChild(1, elementCount);
        this.addChild(2, this.firstKey);
        this.addChild(3, this.elements);
    }

    public int getFirstKey() {
        return this.firstKey.get();
    }

    public void setFirstKey(int firstKey) {
        this.firstKey.set(firstKey);
    }

    @Override
    public Iterator<PackedSwitchEntry> iterator() {
        return (Iterator)ObjectsUtil.cast(this.elements.iterator());
    }

    @Override
    public PackedSwitchEntry get(int index) {
        return (PackedSwitchEntry)this.elements.get(index);
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void setSize(int size) {
        Object lock = this.requestLock();
        this.elements.setSize(size);
        this.releaseLock(lock);
    }

    void onDataChange(int index, int value) {
        this.replaceBySparse().get(index).set(value);
    }

    public InsSparseSwitchData replaceBySparse() {
        InsSparseSwitchData sparseData = this.mReplacement;
        if (sparseData != null) {
            return sparseData;
        }
        Object lock = this.requestLock();
        InsPackedSwitch packed = this.getSwitch();
        InsSparseSwitch sparse = packed.getSparseSwitchReplacement();
        this.mReplacement = sparseData = (InsSparseSwitchData)Opcode.SPARSE_SWITCH_PAYLOAD.newInstance();
        sparseData.setSwitch(sparse);
        sparseData.fromPackedSwitchData(this.elements);
        this.replace(sparseData);
        this.releaseLock(lock);
        return sparseData;
    }

    @Override
    public Opcode<InsPackedSwitch> getSwitchOpcode() {
        return Opcode.PACKED_SWITCH;
    }

    @Override
    public InsPackedSwitch getSwitch() {
        return (InsPackedSwitch)super.getSwitch();
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.PACKED_SWITCH;
    }

    public Iterator<PackedSwitchEntry> getLabels() {
        return this.elements.getLabels();
    }

    @Override
    public void merge(Ins ins) {
        InsPackedSwitchData switchData = (InsPackedSwitchData)ins;
        this.setFirstKey(switchData.getFirstKey());
        this.elements.merge(switchData.elements);
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        this.validateOpcode(smaliInstruction);
        SmaliPayloadPackedSwitch smaliPayloadPackedSwitch = (SmaliPayloadPackedSwitch)smaliInstruction;
        this.setFirstKey(smaliPayloadPackedSwitch.getFirstKey());
        this.elements.fromSmali(smaliPayloadPackedSwitch);
    }

    @Override
    void toSmaliOperand(SmaliInstruction instruction) {
        super.toSmaliOperand(instruction);
        SmaliInstructionOperand.SmaliHexOperand operand = (SmaliInstructionOperand.SmaliHexOperand)instruction.getOperand();
        operand.setNumber(this.getFirstKey());
    }

    @Override
    void toSmaliEntries(SmaliInstruction instruction) {
        super.toSmaliEntries(instruction);
        this.elements.toSmali((SmaliPayloadPackedSwitch)instruction);
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        this.getSmaliDirective().append(writer);
        writer.append(HexUtil.toHex(this.firstKey.get(), 1));
        writer.indentPlus();
        this.elements.append(writer);
        writer.indentMinus();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public String toString() {
        return "InsPackedSwitchData{, firstKey=" + this.firstKey + ", elements=" + this.elements + '}';
    }
}

