/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.arsc.item.ShortItem;
import com.reandroid.common.ArraySupplier;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsSparseSwitch;
import com.reandroid.dex.ins.InsSwitchPayload;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PackedSwitchDataList;
import com.reandroid.dex.ins.PackedSwitchEntry;
import com.reandroid.dex.ins.SparseSwitchEntry;
import com.reandroid.dex.ins.SparseSwitchEntryKey;
import com.reandroid.dex.ins.SwitchEntry;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliPayloadSparseSwitch;
import com.reandroid.dex.smali.model.SmaliSparseSwitchEntry;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArraySupplierIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;

public class InsSparseSwitchData
extends InsSwitchPayload<SparseSwitchEntry> {
    private final ShortItem elementCount = new ShortItem();
    final CountedBlockList<IntegerItem> elements = new CountedBlockList<IntegerItem>(IntegerItem.CREATOR, this.elementCount);
    final CountedBlockList<SparseSwitchEntryKey> keys = new CountedBlockList<SparseSwitchEntryKey>(SparseSwitchEntryKey.CREATOR, this.elementCount);
    boolean mSortRequired;

    public InsSparseSwitchData() {
        super(3, Opcode.SPARSE_SWITCH_PAYLOAD);
        this.addChild(1, this.elementCount);
        this.addChild(2, this.elements);
        this.addChild(3, this.keys);
    }

    @Override
    public Iterator<SparseSwitchEntry> iterator() {
        return (Iterator)ObjectsUtil.cast(this.getLabels());
    }

    @Override
    public SparseSwitchEntry get(int index) {
        if (index < 0 || index >= this.size()) {
            return null;
        }
        return new SparseSwitchEntry(this, (IntegerReference)this.elements.get(index), (SparseSwitchEntryKey)this.keys.get(index));
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    @Override
    public void setSize(int size) {
        Object lock = this.requestLock();
        this.elements.setSize(size);
        this.keys.setSize(size);
        this.elementCount.set(size);
        this.releaseLock(lock);
    }

    public boolean remove(SwitchEntry entry) {
        if (!(entry instanceof SparseSwitchEntry)) {
            return false;
        }
        SparseSwitchEntry switchEntry = (SparseSwitchEntry)entry;
        Object lock = this.requestLock();
        boolean removed = this.elements.remove((IntegerItem)switchEntry.getElement());
        if (removed) {
            this.keys.remove(switchEntry.getEntryKey());
        }
        this.releaseLock(lock);
        return removed;
    }

    public void sort() {
        if (!this.mSortRequired) {
            return;
        }
        this.mSortRequired = false;
        Comparator comparator = (item1, item2) -> CompareUtil.compare(item1.get(), item2.get());
        if (!this.elements.needsSort(comparator)) {
            return;
        }
        this.elements.sort(comparator, this.keys);
    }

    public Iterator<SparseSwitchEntry> getLabels() {
        return new ArraySupplierIterator<SparseSwitchEntry>(new ArraySupplier<SparseSwitchEntry>(){

            @Override
            public SparseSwitchEntry get(int i) {
                return InsSparseSwitchData.this.get(i);
            }

            @Override
            public int getCount() {
                return InsSparseSwitchData.this.size();
            }
        });
    }

    public int getBaseAddress() {
        InsSparseSwitch sparseSwitch = this.getSwitch();
        if (sparseSwitch == null) {
            return 0;
        }
        return sparseSwitch.getAddress();
    }

    @Override
    public Opcode<InsSparseSwitch> getSwitchOpcode() {
        return Opcode.SPARSE_SWITCH;
    }

    @Override
    public InsSparseSwitch getSwitch() {
        return (InsSparseSwitch)super.getSwitch();
    }

    @Override
    protected void onPreRefresh() {
        this.sort();
        super.onPreRefresh();
    }

    void fromPackedSwitchData(PackedSwitchDataList packedSwitchDataList) {
        int length = packedSwitchDataList.size();
        this.setSize(length);
        for (int i = 0; i < length; ++i) {
            this.get(i).fromPackedSwitch((PackedSwitchEntry)packedSwitchDataList.get(i));
        }
    }

    @Override
    public void merge(Ins ins) {
        InsSparseSwitchData switchData = (InsSparseSwitchData)ins;
        int size = switchData.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            this.get(i).merge(switchData.get(i));
        }
    }

    @Override
    public void fromSmali(SmaliInstruction smaliInstruction) {
        this.validateOpcode(smaliInstruction);
        SmaliPayloadSparseSwitch smaliPayload = (SmaliPayloadSparseSwitch)smaliInstruction;
        int count = smaliPayload.getCount();
        this.setSize(count);
        for (int i = 0; i < count; ++i) {
            this.get(i).fromSmali((SmaliSparseSwitchEntry)smaliPayload.getEntry(i));
        }
        this.mSortRequired = true;
    }

    @Override
    void toSmaliEntries(SmaliInstruction instruction) {
        super.toSmaliEntries(instruction);
        SmaliPayloadSparseSwitch smaliPayload = (SmaliPayloadSparseSwitch)instruction;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            smaliPayload.addEntry(this.get(i).toSmali());
        }
    }

    @Override
    public void appendCode(SmaliWriter writer) throws IOException {
        writer.append('.');
        writer.append(this.getSmaliDirective().getName());
        int size = this.size();
        writer.indentPlus();
        for (int i = 0; i < size; ++i) {
            this.get(i).append(writer);
        }
        writer.indentMinus();
        writer.newLine();
        this.getSmaliDirective().appendEnd(writer);
    }

    @Override
    public SmaliDirective getSmaliDirective() {
        return SmaliDirective.SPARSE_SWITCH;
    }
}

