/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.Register;
import com.reandroid.dex.common.RegistersTable;
import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.ExtraLine;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsSwitch;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PayloadData;
import com.reandroid.dex.ins.SwitchEntry;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliRegion;
import com.reandroid.utils.ObjectsUtil;
import java.util.Iterator;
import java.util.List;

public abstract class InsSwitchPayload<T extends SwitchEntry>
extends PayloadData<T>
implements LabelsSet,
SmaliRegion,
SmaliFormat {
    private InsSwitch insSwitch;

    public InsSwitchPayload(int childesCount, Opcode<?> opcode) {
        super(childesCount, opcode);
    }

    @Override
    public void updateTargetAddress() {
        super.updateTargetAddress();
        this.getSwitch().setTargetIns(this);
        this.getSwitch().updateTargetAddress();
        for (SwitchEntry switchEntry : this) {
            switchEntry.updateTargetAddress();
        }
    }

    @Override
    void linkTargetIns() {
        super.linkTargetIns();
        for (SwitchEntry switchEntry : this) {
            switchEntry.getTargetIns();
        }
    }

    @Override
    void unLinkTargetIns() {
        super.unLinkTargetIns();
        for (SwitchEntry switchEntry : this) {
            switchEntry.setTargetIns(null);
        }
    }

    @Override
    public Iterator<IntegerReference> getReferences() {
        return (Iterator)ObjectsUtil.cast(this.iterator());
    }

    public InsSwitch getSwitch() {
        InsSwitch insSwitch = this.insSwitch;
        if (insSwitch == null) {
            insSwitch = this.findOnExtraLines();
            if (insSwitch == null) {
                insSwitch = this.findByAddress();
            }
            this.insSwitch = insSwitch;
            if (insSwitch != null) {
                insSwitch.setPayload(this);
            }
        }
        return insSwitch;
    }

    public void setSwitch(InsSwitch insSwitch) {
        if (insSwitch == null) {
            this.insSwitch = null;
        } else {
            if (this.getSwitchOpcode() != insSwitch.getOpcode()) {
                throw new ClassCastException("Incompatible switch opcode: '" + this.getSwitchOpcode() + "' vs '" + insSwitch.getOpcode() + "'");
            }
            this.insSwitch = insSwitch;
            this.addExtraLine(insSwitch);
            insSwitch.setPayload(this);
        }
    }

    public abstract Opcode<? extends InsSwitch> getSwitchOpcode();

    private InsSwitch findOnExtraLines() {
        Iterator<ExtraLine> iterator = this.getExtraLines();
        while (iterator.hasNext()) {
            InsSwitch insSwitch;
            ExtraLine extraLine = iterator.next();
            if (!(extraLine instanceof InsSwitch) || (insSwitch = (InsSwitch)extraLine).getOpcode() != this.getSwitchOpcode()) continue;
            return insSwitch;
        }
        return null;
    }

    private InsSwitch findByAddress() {
        InstructionList instructionList = this.getInstructionList();
        if (instructionList != null) {
            Iterator<InsSwitch> iterator = instructionList.iterator(this.getSwitchOpcode());
            int address = this.getAddress();
            while (iterator.hasNext()) {
                InsSwitch sparseSwitch = iterator.next();
                if (sparseSwitch.getTargetAddress() != address) continue;
                return sparseSwitch;
            }
        }
        return null;
    }

    public boolean replaceByIfEq() {
        InstructionList instructionList = this.getInstructionList();
        RegistersTable registersTable = instructionList.getRegistersTable();
        int local = registersTable.getLocalRegistersCount();
        int constRegister = local++;
        InsSwitch insSwitch = this.getSwitch();
        if (!registersTable.ensureLocalRegistersCount(local)) {
            List<Register> freeRegisters = instructionList.getLocalFreeRegisters(insSwitch.getIndex());
            if (freeRegisters.isEmpty()) {
                return false;
            }
            constRegister = freeRegisters.get(0).getValue();
        }
        if (constRegister > 15) {
            return false;
        }
        this.replaceByIfEq(constRegister);
        return true;
    }

    public void replaceByIfEq(int constRegister) {
        InsSwitch packedSwitch = this.getSwitch();
        InsBlockList insBlockList = this.getInsBlockList();
        Object lock = insBlockList.link(new Object());
        this.linkTargetIns();
        for (SwitchEntry switchEntry : this) {
            switchEntry.addEquivalentIfEq(constRegister);
        }
        InstructionList instructionList = this.getInstructionList();
        instructionList.remove(packedSwitch);
        instructionList.remove(this);
        insBlockList.unlinkLocked(lock);
    }
}

