/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.container.CountedBlockList;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.ins.InsPackedSwitch;
import com.reandroid.dex.ins.InsPackedSwitchData;
import com.reandroid.dex.ins.LabelsSet;
import com.reandroid.dex.ins.PackedSwitchEntry;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliPackedSwitchEntry;
import com.reandroid.dex.smali.model.SmaliPayloadPackedSwitch;
import com.reandroid.dex.smali.model.SmaliSet;
import java.io.IOException;
import java.util.Iterator;

public class PackedSwitchDataList
extends CountedBlockList<PackedSwitchEntry>
implements SmaliFormat,
LabelsSet {
    private final InsPackedSwitchData switchData;

    public PackedSwitchDataList(InsPackedSwitchData switchData, IntegerReference itemCount) {
        super(InsPackedSwitchData.CREATOR, itemCount);
        this.switchData = switchData;
    }

    public int getFirstKey() {
        return this.switchData.getFirstKey();
    }

    public int getBaseAddress() {
        InsPackedSwitch packedSwitch = this.switchData.getSwitch();
        if (packedSwitch == null) {
            return 0;
        }
        return packedSwitch.getAddress();
    }

    public InsPackedSwitchData getSwitchData() {
        return this.switchData;
    }

    void onDataChange(int index, int value) {
        this.switchData.onDataChange(index, value);
    }

    public void merge(PackedSwitchDataList dataList) {
        int size = dataList.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((PackedSwitchEntry)this.get(i)).merge((PackedSwitchEntry)dataList.get(i));
        }
    }

    public void fromSmali(SmaliPayloadPackedSwitch smali) {
        SmaliSet entries = smali.getEntries();
        int size = entries.size();
        this.setSize(size);
        for (int i = 0; i < size; ++i) {
            ((PackedSwitchEntry)this.get(i)).fromSmali((SmaliPackedSwitchEntry)entries.get(i));
        }
    }

    public void toSmali(SmaliPayloadPackedSwitch smali) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            smali.addEntry(((PackedSwitchEntry)this.get(i)).toSmali());
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((PackedSwitchEntry)this.get(i)).append(writer);
        }
    }

    public Iterator<PackedSwitchEntry> getLabels() {
        return this.iterator();
    }
}

