/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsPackedSwitchData;
import com.reandroid.dex.ins.PackedSwitchDataList;
import com.reandroid.dex.ins.SwitchEntry;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliPackedSwitchEntry;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class PackedSwitchEntry
extends IntegerItem
implements SwitchEntry {
    private Ins targetIns;

    @Override
    public Ins getTargetIns() {
        Ins targetIns = this.targetIns;
        if (targetIns == null) {
            this.setTargetIns(this.findTargetIns());
            targetIns = this.targetIns;
        }
        return targetIns;
    }

    @Override
    public void setTargetIns(Ins targetIns) {
        if (targetIns != this.targetIns) {
            this.targetIns = targetIns;
            if (targetIns != null) {
                targetIns.addExtraLine(this);
            }
        }
    }

    @Override
    public InsPackedSwitchData getPayload() {
        return this.getParentDataList().getSwitchData();
    }

    @Override
    public int get() {
        return this.getParentDataList().getFirstKey() + this.getIndex();
    }

    @Override
    public void set(int value) {
        if (value != this.get()) {
            this.getParentDataList().onDataChange(this.getIndex(), value);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.newLine();
        writer.appendLabelName(this.getLabelName());
        int value = this.get();
        writer.appendComment(HexUtil.toHex(value, 1));
        writer.appendResourceIdComment(value);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        writer.appendLabelName(this.getLabelName());
        writer.appendComment(HexUtil.toHex(this.get(), 1));
    }

    @Override
    public int getAddress() {
        return super.get();
    }

    public void setAddress(int address) {
        super.set(address);
    }

    @Override
    public int getTargetAddress() {
        return this.getParentDataList().getBaseAddress() + this.getAddress();
    }

    @Override
    public void setTargetAddress(int targetAddress) {
        this.setAddress(targetAddress - this.getParentDataList().getBaseAddress());
    }

    @Override
    public String getLabelName() {
        return HexUtil.toHex(":pswitch_", this.getTargetAddress(), 1);
    }

    private PackedSwitchDataList getParentDataList() {
        return (PackedSwitchDataList)this.getParent();
    }

    @Override
    public int getSortOrder() {
        return 5;
    }

    public void merge(PackedSwitchEntry data) {
        this.setAddress(data.getAddress());
    }

    public void fromSmali(SmaliPackedSwitchEntry smaliEntry) {
        this.setAddress(smaliEntry.getRelativeOffset());
    }

    public SmaliPackedSwitchEntry toSmali() {
        SmaliPackedSwitchEntry entry = new SmaliPackedSwitchEntry();
        entry.getLabel().setLabelName(this.getLabelName());
        return entry;
    }

    public int hashCode() {
        return this.getIndex();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PackedSwitchEntry data = (PackedSwitchEntry)obj;
        return this.getIndex() == data.getIndex() && this.getParent() == data.getParent();
    }

    @Override
    public String toString() {
        return this.getLabelName();
    }
}

