/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.InsSparseSwitchData;
import com.reandroid.dex.ins.PackedSwitchEntry;
import com.reandroid.dex.ins.SparseSwitchEntryKey;
import com.reandroid.dex.ins.SwitchEntry;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliSparseSwitchEntry;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import java.io.IOException;

public class SparseSwitchEntry
implements SwitchEntry {
    private final InsSparseSwitchData payload;
    private final IntegerReference element;
    private final SparseSwitchEntryKey entryKey;

    public SparseSwitchEntry(InsSparseSwitchData payload, IntegerReference element, SparseSwitchEntryKey entryKey) {
        this.payload = payload;
        this.element = element;
        this.entryKey = entryKey;
    }

    @Override
    public InsSparseSwitchData getPayload() {
        return this.payload;
    }

    @Override
    public int get() {
        return this.element.get();
    }

    @Override
    public void set(int value) {
        if (value != this.element.get()) {
            this.element.set(value);
            this.payload.mSortRequired = true;
        }
    }

    @Override
    public int getIndex() {
        return this.entryKey.getIndex();
    }

    @Override
    public Ins getTargetIns() {
        Ins targetIns = this.entryKey.getTargetIns();
        if (targetIns == null) {
            this.setTargetIns(this.findTargetIns());
            targetIns = this.entryKey.getTargetIns();
        }
        return targetIns;
    }

    @Override
    public void setTargetIns(Ins targetIns) {
        Ins ins = this.entryKey.getTargetIns();
        if (targetIns != ins) {
            this.entryKey.setTargetIns(targetIns);
            if (targetIns != null) {
                targetIns.addExtraLine(this);
            }
        }
    }

    SparseSwitchEntryKey getEntryKey() {
        return this.entryKey;
    }

    IntegerReference getElement() {
        return this.element;
    }

    public int getKey() {
        return this.entryKey.get();
    }

    public void setKey(int value) {
        this.entryKey.set(value);
    }

    @Override
    public int getSortOrder() {
        return 5;
    }

    @Override
    public int getAddress() {
        return this.payload.getAddress();
    }

    @Override
    public int getTargetAddress() {
        return this.getKey() + this.payload.getBaseAddress();
    }

    @Override
    public void setTargetAddress(int targetAddress) {
        this.setKey(targetAddress - this.payload.getBaseAddress());
    }

    @Override
    public String getLabelName() {
        return HexUtil.toHex(":sswitch_", this.getTargetAddress(), 1);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.newLine();
        int value = this.get();
        writer.appendHex(value);
        writer.append(" -> ");
        writer.appendLabelName(this.getLabelName());
        writer.appendResourceIdComment(value);
    }

    @Override
    public void appendExtra(SmaliWriter writer) throws IOException {
        writer.appendLabelName(this.getLabelName());
        writer.appendComment(HexUtil.toSignedHex(this.get()));
    }

    public void removeSelf() {
        this.payload.remove(this);
    }

    public void fromPackedSwitch(PackedSwitchEntry packedSwitchEntry) {
        this.set(packedSwitchEntry.get());
        Ins ins = packedSwitchEntry.getTargetIns();
        this.setTargetAddress(ins.getAddress());
        this.setTargetIns(ins);
        ins.addExtraLine(this);
    }

    public void merge(SparseSwitchEntry data) {
        this.set(data.get());
        this.setKey(data.getKey());
    }

    public void fromSmali(SmaliSparseSwitchEntry smaliEntry) {
        this.set(smaliEntry.getValue());
        this.setKey(smaliEntry.getRelativeOffset());
    }

    public SmaliSparseSwitchEntry toSmali() {
        SmaliSparseSwitchEntry entry = new SmaliSparseSwitchEntry();
        entry.getLabel().setLabelName(this.getLabelName());
        entry.setValue(this.get());
        return entry;
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.payload, this.element);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SparseSwitchEntry data = (SparseSwitchEntry)obj;
        return this.element == data.element && this.payload == data.payload;
    }

    public String toString() {
        return HexUtil.toHex8(this.get()) + " -> " + this.getKey();
    }
}

