/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.ins;

import com.reandroid.dex.data.InstructionList;
import com.reandroid.dex.ins.Ins;
import com.reandroid.dex.ins.Ins22t;
import com.reandroid.dex.ins.InsBlockList;
import com.reandroid.dex.ins.InsSwitch;
import com.reandroid.dex.ins.InsSwitchPayload;
import com.reandroid.dex.ins.Label;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.ins.PayloadEntry;

public interface SwitchEntry
extends PayloadEntry,
Label {
    public InsSwitchPayload<?> getPayload();

    @Override
    default public boolean isRemoved() {
        return this.getPayload().isRemoved();
    }

    default public void updateTargetAddress() {
        Ins target = this.getTargetIns();
        this.setTargetAddress(target.getAddress());
    }

    default public void addEquivalentIfEq(int constRegister) {
        InsSwitch insSwitch = ((InsSwitchPayload)this.getPayload()).getSwitch();
        InstructionList instructionList = insSwitch.getInstructionList();
        Ins targetIns = this.getTargetIns();
        Ins constNumberIns = (Ins)((Object)instructionList.createConstIntegerAt(insSwitch.getIndex() + 1, constRegister, this.get()));
        Ins22t insIfEq = (Ins22t)Opcode.IF_EQ.newInstance();
        insIfEq.setRegister(0, insSwitch.getRegister());
        insIfEq.setRegister(1, constRegister);
        insIfEq.setTargetIns(targetIns);
        instructionList.add(constNumberIns.getIndex() + 1, insIfEq);
        insIfEq.setTargetIns(targetIns);
    }

    default public Ins findTargetIns() {
        InsBlockList insBlockList = this.getPayload().getInsBlockList();
        if (insBlockList != null) {
            return insBlockList.getAtAddress(this.getTargetAddress());
        }
        return null;
    }
}

