/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.key.Key;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.StringsUtil;

public class DataKey<T extends DataItem>
implements Key {
    private final T item;

    public DataKey(T item) {
        this.item = item;
    }

    public T getItem() {
        return this.item;
    }

    private int getOffset() {
        return ((SectionItemContainer)this.getItem()).getOffset();
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return StringsUtil.compareToString(this, obj);
        }
        DataKey key = (DataKey)obj;
        if (this.getItem().equals(key.getItem())) {
            return 0;
        }
        int i = CompareUtil.compareUnsigned(((Block)this.getItem()).getIndex(), ((Block)key.getItem()).getIndex());
        if (i != 0) {
            return i;
        }
        return 1;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DataKey key = (DataKey)obj;
        return this.item.equals(key.item);
    }

    public int hashCode() {
        return this.item.hashCode();
    }

    public String toString() {
        return this.getOffset() + ": {" + this.getItem() + "}";
    }
}

