/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayIterator;
import com.reandroid.utils.collection.ArraySort;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Predicate;

public abstract class KeyList<T extends Key>
implements Key,
Iterable<T> {
    static final Key[] EMPTY_ARRAY = new Key[0];
    private final Key[] elements;
    private final Key[] sortedElements;
    private int mHash;

    public KeyList(Key[] elements, boolean sorted) {
        this.elements = elements;
        this.sortedElements = sorted ? KeyList.sortElements((Key[])elements) : null;
    }

    public KeyList(Key[] elements) {
        this(elements, false);
    }

    public T get(int i) {
        Key[] elements = this.elements;
        if (i >= 0 && i < elements.length) {
            return (T)elements[i];
        }
        return null;
    }

    public int size() {
        return this.elements.length;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Iterator<T> iterator() {
        return ArrayIterator.of(this.elements);
    }

    public Iterator<T> iterator(Predicate<? super T> predicate) {
        return ArrayIterator.of(this.elements, predicate);
    }

    public <T1 extends Key> Iterator<T1> iterator(Class<T1> instance) {
        return InstanceIterator.of(this.iterator(), instance);
    }

    public int indexOf(Object key) {
        Key[] elements = this.elements;
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            if (!ObjectsUtil.equals(elements[i], key)) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(Object item) {
        Key[] elements = this.elements;
        int length = elements.length;
        for (int i = 0; i < length; ++i) {
            if (!ObjectsUtil.equals(elements[i], item)) continue;
            return true;
        }
        return false;
    }

    public KeyList<T> set(int i, T item) {
        if (ObjectsUtil.equals(item, this.get(i))) {
            return this;
        }
        Key[] elements = (Key[])this.elements.clone();
        elements[i] = item;
        return this.newInstance(elements);
    }

    public KeyList<T> add(T item) {
        Key[] elements = this.elements;
        int length = elements.length;
        Key[] result = this.newArray(length + 1);
        for (int i = 0; i < length; ++i) {
            result[i] = elements[i];
        }
        result[length] = item;
        return this.newInstance(result);
    }

    public KeyList<T> remove(T itemKey) {
        return this.remove(this.indexOf(itemKey));
    }

    public KeyList<T> remove(int index) {
        if (index < 0) {
            return this;
        }
        Key[] elements = this.elements;
        int length = elements.length;
        if (index >= length) {
            return this;
        }
        if (length == 1) {
            return this.newInstance(this.newArray(0));
        }
        Key[] result = this.newArray(length - 1);
        int j = 0;
        for (int i = 0; i < length; ++i) {
            if (i == index) continue;
            result[j] = elements[i];
            ++j;
        }
        return this.newInstance(result);
    }

    public KeyList<T> removeIf(Predicate<? super T> predicate) {
        Key[] elements = this.elements;
        int length = elements.length;
        if (length == 0) {
            return this;
        }
        Key[] filtered = null;
        int j = 0;
        for (int i = 0; i < length; ++i) {
            Key item = elements[i];
            if (predicate.test(item)) {
                if (filtered != null) continue;
                filtered = (Key[])elements.clone();
                j = i;
                continue;
            }
            if (filtered == null) continue;
            filtered[j] = item;
            ++j;
        }
        if (filtered == null) {
            return this;
        }
        Key[] result = this.newArray(j);
        length = result.length;
        for (int i = 0; i < length; ++i) {
            result[i] = filtered[i];
        }
        return this.newInstance(result);
    }

    public T getDuplicate() {
        Key[] elements = this.getSortedElements();
        int length = elements.length;
        if (length < 2) {
            return null;
        }
        Key last = elements[0];
        for (int i = 1; i < length; ++i) {
            Key element = elements[i];
            if (ObjectsUtil.equals(last, element)) {
                return (T)element;
            }
            last = element;
        }
        return null;
    }

    public KeyList<T> clearDuplicates() {
        return this.clearDuplicates(CompareUtil.getComparableComparator());
    }

    public KeyList<T> clearDuplicates(Comparator<? super T> comparator) {
        Key[] elements = this.getSortedElements();
        if (elements.length < 2) {
            return this;
        }
        if ((elements = KeyList.sortElements((Key[])elements, comparator)) == null) {
            elements = this.getSortedElements();
        }
        Comparator c = (Comparator)ObjectsUtil.cast(comparator);
        int length = elements.length;
        Key previous = elements[0];
        Key[] results = null;
        for (int i = 1; i < length; ++i) {
            Key element = elements[i];
            if (c.compare(previous, element) == 0) {
                if (results == null) {
                    results = (Key[])elements.clone();
                }
                results[i] = null;
            }
            previous = element;
        }
        if (results == null) {
            return this;
        }
        results = KeyList.removeNulls(results);
        return this.newInstance(results);
    }

    public KeyList<T> sorted() {
        Key[] elements = this.sortedElements;
        if (elements == null) {
            return this;
        }
        return this.newInstance(elements);
    }

    public KeyList<T> sort(Comparator<? super T> comparator) {
        Object[] elements = this.elements;
        int length = elements.length;
        if (length < 2) {
            return this;
        }
        boolean sortRequired = false;
        Key previous = elements[0];
        for (int i = 1; i < length; ++i) {
            Key item = elements[i];
            if (comparator.compare(previous, item) > 0) {
                sortRequired = true;
                break;
            }
            previous = item;
        }
        if (!sortRequired) {
            return this;
        }
        elements = (Key[])elements.clone();
        ArraySort.sort(elements, comparator);
        return this.newInstance((Key[])elements);
    }

    private Key[] getSortedElements() {
        Key[] elements = this.sortedElements;
        if (elements == null) {
            elements = this.elements;
        }
        return elements;
    }

    Key[] getElements() {
        return this.elements;
    }

    abstract KeyList<T> newInstance(Key[] var1);

    private Key[] newArray(int length) {
        if (length == 0) {
            return EMPTY_ARRAY;
        }
        return new Key[length];
    }

    @Override
    public KeyList<T> replaceKey(Key search, Key replace) {
        if (this.equals(search)) {
            return (KeyList)replace;
        }
        return this.replaceElements(search, replace);
    }

    KeyList<T> replaceElements(Key search, Key replace) {
        KeyList<T> result = this;
        int size = result.size();
        for (int i = 0; i < size; ++i) {
            Object item = this.get(i);
            if (item == null) continue;
            item = item.replaceKey(search, replace);
            result = result.set(i, item);
        }
        return result;
    }

    @Override
    public Iterator<? extends Key> mentionedKeys() {
        return CombiningIterator.singleOne(this, new IterableIterator<T, Key>(this.iterator()){

            @Override
            public Iterator<Key> iterator(T element) {
                return (Iterator)ObjectsUtil.cast(element.mentionedKeys());
            }
        });
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendAll(this.iterator());
    }

    int compareElements(KeyList<?> keyList) {
        return CompareUtil.compare(this.getSortedElements(), super.getSortedElements());
    }

    boolean equalsElements(KeyList<?> keyList) {
        return ObjectsUtil.equalsArray(this.getSortedElements(), super.getSortedElements());
    }

    int getHashCode() {
        int hash = this.mHash;
        if (hash == 0) {
            this.mHash = hash = this.computeHash();
        }
        return hash;
    }

    int computeHash() {
        return ObjectsUtil.hashElements(this.getSortedElements());
    }

    public int hashCode() {
        return this.getHashCode();
    }

    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }

    public static <T1 extends Key> boolean equalsIgnoreEmpty(KeyList<T1> key1, KeyList<T1> key2) {
        if (key1 == key2) {
            return true;
        }
        if (key1 == null || key1.isEmpty()) {
            return key2 == null || key2.isEmpty();
        }
        if (key2 == null || key2.isEmpty()) {
            return key1.isEmpty();
        }
        return key1.equalsElements(key2);
    }

    private static <T extends Key> T[] sortElements(T[] elements) {
        return KeyList.sortElements(elements, CompareUtil.getComparableComparator());
    }

    private static <T extends Key, E extends Key> T[] sortElements(T[] elements, Comparator<? super E> comparator) {
        if (elements == null || elements.length < 2) {
            return null;
        }
        boolean needsSort = false;
        int length = elements.length;
        T previous = elements[0];
        Comparator c = (Comparator)ObjectsUtil.cast(comparator);
        for (int i = 1; i < length; ++i) {
            T next = elements[i];
            if (c.compare(previous, next) > 0) {
                needsSort = true;
                break;
            }
            previous = next;
        }
        if (!needsSort) {
            return null;
        }
        elements = (Key[])elements.clone();
        ArraySort.sort(elements, c);
        return elements;
    }

    static Key[] removeNulls(Key[] elements) {
        if (elements == null || elements.length == 0) {
            return EMPTY_ARRAY;
        }
        int length = elements.length;
        int size = 0;
        for (int i = 0; i < length; ++i) {
            Key key = elements[i];
            if (key == null) continue;
            ++size;
        }
        if (size == length) {
            return elements;
        }
        if (size == 0) {
            return EMPTY_ARRAY;
        }
        Key[] results = new Key[size];
        int j = 0;
        for (int i = 0; i < length; ++i) {
            Key key = elements[i];
            if (key == null) continue;
            results[j] = key;
            ++j;
        }
        return results;
    }
}

