/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.ArrayKey;
import com.reandroid.dex.key.DalvikSignatureBuilder;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.ParameterisedTypeKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;

public class ParameterisedProtoKey
extends ArrayKey<ParameterisedTypeKey> {
    public static final ParameterisedProtoKey EMPTY = new ParameterisedProtoKey(false, null, EMPTY_ARRAY);
    private final boolean method;
    private final ParameterisedTypeKey returnType;

    private ParameterisedProtoKey(boolean method, ParameterisedTypeKey returnType, Key[] elements) {
        super(elements);
        this.method = method;
        this.returnType = returnType;
    }

    public boolean isMethod() {
        return this.method;
    }

    public ParameterisedTypeKey getReturnType() {
        return this.returnType;
    }

    public ParameterisedProtoKey changeReturnType(ParameterisedTypeKey returnType) {
        if (ObjectsUtil.equals(this.getReturnType(), returnType)) {
            return this;
        }
        return ParameterisedProtoKey.create(this.isMethod(), returnType, this.getElements());
    }

    public boolean isBlank() {
        return this.isEmpty() && this.getReturnType() == null;
    }

    public Iterator<TypeKey> getTypes() {
        ParameterisedTypeKey returnType = this.getReturnType();
        Iterator<Object> iterator2 = returnType != null ? returnType.getTypes() : EmptyIterator.of();
        return CombiningIterator.two(new IterableIterator<ParameterisedTypeKey, TypeKey>(this.iterator()){

            @Override
            public Iterator<TypeKey> iterator(ParameterisedTypeKey element) {
                return element.getTypes();
            }
        }, iterator2);
    }

    @Override
    public ParameterisedProtoKey replaceKey(Key search, Key replace) {
        ParameterisedProtoKey result = (ParameterisedProtoKey)super.replaceKey(search, replace);
        ParameterisedTypeKey returnType = result.getReturnType();
        if (returnType != null) {
            result = result.changeReturnType(returnType.replaceKey(search, replace));
        }
        return result;
    }

    @Override
    public Iterator<? extends Key> mentionedKeys() {
        return super.mentionedKeys();
    }

    void buildSignature(DalvikSignatureBuilder builder) {
        ParameterisedTypeKey returnType = this.getReturnType();
        if (this.isBlank()) {
            return;
        }
        boolean method = this.isMethod();
        builder.append(method ? (char)'(' : '<');
        builder.flushPending();
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((ParameterisedTypeKey)this.get(i)).buildSignature(builder);
        }
        builder.append(method ? (char)')' : '>');
        if (returnType != null) {
            returnType.buildSignature(builder);
        }
    }

    void appendString(StringBuilder builder, boolean comment) {
        ParameterisedTypeKey returnType = this.getReturnType();
        if (this.isBlank()) {
            return;
        }
        boolean method = this.isMethod();
        builder.append(method ? (char)'(' : '<');
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ((ParameterisedTypeKey)this.get(i)).appendString(builder, comment);
        }
        builder.append(method ? (char)')' : '>');
        if (returnType != null) {
            returnType.appendString(builder, comment);
        }
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (obj == null) {
            return -1;
        }
        if (!(obj instanceof ParameterisedProtoKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        ParameterisedProtoKey key = (ParameterisedProtoKey)obj;
        int i = CompareUtil.compare(this.getReturnType(), key.getReturnType());
        if (i == 0) {
            i = super.compareElements(key);
        }
        return i;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ParameterisedProtoKey)) {
            return false;
        }
        ParameterisedProtoKey key = (ParameterisedProtoKey)obj;
        return ObjectsUtil.equals(this.getReturnType(), key.getReturnType()) && this.equalsElements(key);
    }

    @Override
    public int hashCode() {
        return ObjectsUtil.hash(this.getReturnType()) * 31 + this.getHashCode();
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.appendString(builder, false);
        return builder.toString();
    }

    @Override
    protected ParameterisedProtoKey newInstance(Key[] elements) {
        boolean method = this.isMethod();
        ParameterisedTypeKey returnType = this.getReturnType();
        if (elements.length == 0) {
            if (!method && returnType == null) {
                return EMPTY;
            }
            elements = EMPTY_ARRAY;
        }
        return new ParameterisedProtoKey(method, returnType, elements);
    }

    public static ParameterisedProtoKey create(boolean method, ParameterisedTypeKey returnType, Key[] elements) {
        if (elements == null || elements.length == 0) {
            if (returnType == null) {
                return EMPTY;
            }
            elements = EMPTY_ARRAY;
        }
        return new ParameterisedProtoKey(method, returnType, elements);
    }

    public static ParameterisedProtoKey read(SmaliReader reader) throws IOException {
        char first = reader.readASCII();
        if (first != '<' && first != '(') {
            reader.position(reader.position() - 1);
            throw new SmaliParseException("Expecting '<' or '(", reader);
        }
        byte endChar = first == '<' ? (byte)62 : 41;
        ArrayCollection<ParameterisedTypeKey> results = null;
        while (!reader.finished() && reader.get() != endChar) {
            if (results == null) {
                results = new ArrayCollection<ParameterisedTypeKey>();
            }
            results.add(ParameterisedTypeKey.read(reader));
        }
        SmaliParseException.expect(reader, (char)endChar);
        ParameterisedTypeKey returnType = endChar == 41 || !reader.finished() && reader.get() == 46 ? ParameterisedTypeKey.read(reader) : null;
        Key[] elements = results != null ? results.toArrayFill(new Key[results.size()]) : null;
        return ParameterisedProtoKey.create(endChar == 41, returnType, elements);
    }
}

