/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.key;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.SingleIterator;
import java.io.IOException;
import java.util.Iterator;

public class ProtoKey
implements Key {
    private final TypeListKey parameters;
    private final TypeKey returnType;

    private ProtoKey(TypeListKey parameters, TypeKey returnType) {
        this.parameters = parameters;
        this.returnType = returnType;
    }

    public int getRegister(int index) {
        int result = 0;
        int size = this.getParametersCount();
        if (index < size) {
            size = index;
        }
        for (int i = 0; i < size; ++i) {
            TypeKey typeKey = this.getParameter(i);
            ++result;
            if (!typeKey.isWide()) continue;
            ++result;
        }
        return result;
    }

    public int getParameterIndex(int register) {
        int size = this.getParametersCount();
        int registerCount = 0;
        for (int i = 0; i < size; ++i) {
            if (registerCount == register) {
                return i;
            }
            TypeKey typeKey = this.getParameter(i);
            ++registerCount;
            if (!typeKey.isWide()) continue;
            ++registerCount;
        }
        return -1;
    }

    public ProtoKey removeParameter(int index) {
        return this.changeParameters(this.getParameters().remove(index));
    }

    public ProtoKey changeParameters(TypeListKey typeListKey) {
        if (TypeListKey.equalsIgnoreEmpty(this.getParameters(), typeListKey)) {
            return this;
        }
        return ProtoKey.create(typeListKey, this.getReturnType());
    }

    public ProtoKey changeParameter(int index, TypeKey typeKey) {
        return this.changeParameters(this.getParameters().set(index, typeKey));
    }

    public ProtoKey changeReturnType(TypeKey typeKey) {
        if (this.getReturnType().equals(typeKey)) {
            return this;
        }
        return ProtoKey.create(this.getParameters(), typeKey);
    }

    public TypeKey getReturnType() {
        return this.returnType;
    }

    public int getParametersCount() {
        return this.getParameters().size();
    }

    public TypeKey getParameter(int i) {
        return (TypeKey)this.getParameters().get(i);
    }

    public TypeListKey getParameters() {
        return this.parameters;
    }

    public Iterator<TypeKey> iterator() {
        return this.getParameters().iterator();
    }

    public String getShorty() {
        TypeListKey parameters = this.getParameters();
        int length = 1 + parameters.size();
        char[] results = new char[length];
        results[0] = this.getReturnType().shorty();
        for (int i = 1; i < length; ++i) {
            results[i] = ((TypeKey)parameters.get(i - 1)).shorty();
        }
        return new String(results);
    }

    public int getParameterRegistersCount() {
        int result = 0;
        Iterator<TypeKey> iterator = this.iterator();
        while (iterator.hasNext()) {
            TypeKey key = iterator.next();
            ++result;
            if (!key.isWide()) continue;
            ++result;
        }
        return result;
    }

    public Iterator<Key> mentionedKeys() {
        return CombiningIterator.singleThree(this, SingleIterator.of(StringKey.create(this.getShorty())), this.iterator(), SingleIterator.of(this.getReturnType()));
    }

    @Override
    public ProtoKey replaceKey(Key search, Key replace) {
        ProtoKey result = this;
        if (search.equals(result)) {
            return (ProtoKey)replace;
        }
        if (search.equals(result.getReturnType())) {
            result = result.changeReturnType((TypeKey)replace);
        }
        result = result.changeParameters(this.getParameters().replaceKey(search, replace));
        return result;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append('(');
        writer.appendAll(this.iterator(), false);
        writer.append(')');
        this.getReturnType().append(writer);
    }

    @Override
    public int compareTo(Object obj) {
        if (obj == this) {
            return 0;
        }
        if (!(obj instanceof ProtoKey)) {
            return StringsUtil.compareToString(this, obj);
        }
        ProtoKey key = (ProtoKey)obj;
        int i = CompareUtil.compare(this.getReturnType(), key.getReturnType());
        if (i != 0) {
            return i;
        }
        return CompareUtil.compare(this.getParameters(), key.getParameters());
    }

    public boolean equalsReturnType(TypeKey returnType) {
        return this.getReturnType().equals(returnType);
    }

    public boolean equalsReturnType(ProtoKey protoKey) {
        if (protoKey == null) {
            return false;
        }
        if (protoKey == this) {
            return true;
        }
        return this.getReturnType().equals(protoKey.getReturnType());
    }

    public boolean equalsParameters(TypeListKey parameters) {
        return TypeListKey.equalsIgnoreEmpty(this.getParameters(), parameters);
    }

    public boolean equalsParameters(ProtoKey protoKey) {
        if (protoKey == null) {
            return false;
        }
        if (protoKey == this) {
            return true;
        }
        return TypeListKey.equalsIgnoreEmpty(this.getParameters(), protoKey.getParameters());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProtoKey)) {
            return false;
        }
        ProtoKey protoKey = (ProtoKey)obj;
        return ObjectsUtil.equals(this.getReturnType(), protoKey.getReturnType()) && ObjectsUtil.equals(this.getParameters(), protoKey.getParameters());
    }

    public int hashCode() {
        return ObjectsUtil.hash(this.getParameters(), this.getReturnType());
    }

    public String toString() {
        return this.getParameters().toString() + this.getReturnType();
    }

    public static ProtoKey create(TypeKey returnType, TypeKey ... parameters) {
        return ProtoKey.create(TypeListKey.create(parameters), returnType);
    }

    public static ProtoKey create(TypeListKey typeListKey, TypeKey returnType) {
        if (returnType == null) {
            return null;
        }
        if (typeListKey == null) {
            typeListKey = TypeListKey.empty();
        }
        return new ProtoKey(typeListKey, returnType);
    }

    public static ProtoKey emptyParameters(TypeKey returnType) {
        return ProtoKey.create(TypeListKey.empty(), returnType);
    }

    public static ProtoKey parse(String text) {
        if (text == null) {
            return null;
        }
        return ProtoKey.parse(text, 0);
    }

    public static ProtoKey parse(String text, int start) {
        if (text.length() - start < 3 || text.charAt(start) != '(') {
            return null;
        }
        int i = text.indexOf(41, start);
        if (i < 0) {
            return null;
        }
        TypeListKey parameters = TypeListKey.parseParameters(text, start + 1, i);
        if (parameters == null) {
            return null;
        }
        TypeKey returnType = TypeKey.parseBinaryType(text, i + 1, text.length());
        if (returnType == null) {
            return null;
        }
        return ProtoKey.create(parameters, returnType);
    }

    public static ProtoKey read(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        TypeListKey parameters = TypeListKey.readParameters(reader);
        reader.skipWhitespacesOrComment();
        TypeKey returnType = TypeKey.read(reader);
        return new ProtoKey(parameters, returnType);
    }
}

