/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.common.ReflectionUtil;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.dalvik.DalvikInnerClass;
import com.reandroid.dex.data.ClassData;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.data.MethodDef;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.program.ClassProgram;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliField;
import com.reandroid.dex.smali.model.SmaliMethod;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.utils.collection.UniqueIterator;
import com.reandroid.utils.io.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.function.Predicate;

public class DexClass
extends DexDeclaration
implements ClassProgram,
Comparable<DexClass> {
    private final DexLayout dexLayout;
    private final ClassId classId;

    public DexClass(DexLayout dexLayout, ClassId classId) {
        this.dexLayout = dexLayout;
        this.classId = classId;
    }

    public boolean usesNative() {
        if (this.isNative()) {
            return true;
        }
        Iterator<DexMethod> methods = this.getDeclaredMethods();
        while (methods.hasNext()) {
            DexMethod dexMethod = methods.next();
            if (!dexMethod.isNative()) continue;
            return true;
        }
        Iterator<DexField> fields = this.getDeclaredFields();
        while (fields.hasNext()) {
            DexField dexField = fields.next();
            if (!dexField.isNative()) continue;
            return true;
        }
        return false;
    }

    public void replaceKeys(Key search, Key replace) {
        this.getId().replaceKeys(search, replace);
    }

    public Set<DexClass> getRequired() {
        return this.getRequired(null);
    }

    public Set<DexClass> getRequired(Predicate<TypeKey> exclude) {
        HashSet<DexClass> results = new HashSet<DexClass>();
        results.add(this);
        this.searchRequired(exclude, results);
        return results;
    }

    private void searchRequired(Predicate<TypeKey> exclude, Set<DexClass> results) {
        DexClassRepository dexClassRepository = this.getClassRepository();
        Iterator<TypeKey> iterator = this.usedTypes();
        while (iterator.hasNext()) {
            DexClass dexClass;
            TypeKey typeKey = iterator.next();
            typeKey = typeKey.getDeclaring();
            if (exclude != null && !exclude.test(typeKey) || (dexClass = dexClassRepository.getDexClass(typeKey)) == null || results.contains(dexClass)) continue;
            results.add(dexClass);
            dexClass.searchRequired(exclude, results);
        }
    }

    public Iterator<TypeKey> usedTypes() {
        Iterator<Key> iterator = ComputeIterator.of(this.getId().usedIds(), IdItem::getKey);
        IterableIterator<Key, Key> mentioned = new IterableIterator<Key, Key>(iterator){

            @Override
            public Iterator<Key> iterator(Key element) {
                return element.mentionedKeys();
            }
        };
        return InstanceIterator.of(mentioned, TypeKey.class);
    }

    public DexMethod getStaticConstructor() {
        MethodKey methodKey = MethodKey.STATIC_CONSTRUCTOR.changeDeclaring(this.getDefining());
        return this.getDeclaredMethod(methodKey);
    }

    public DexField getField(FieldKey fieldKey) {
        if (!this.isAccessibleTo(fieldKey.getDeclaring())) {
            return null;
        }
        DexField dexField = this.getDeclaredField(fieldKey);
        if (dexField != null) {
            return dexField;
        }
        DexClass superClass = this.getSuperClass();
        if (superClass != null && (dexField = superClass.getField(fieldKey)) != null) {
            if (dexField.isAccessibleTo(this.getDefining())) {
                return dexField;
            }
            return null;
        }
        Iterator<DexClass> iterator = this.getInterfaceClasses();
        while (iterator.hasNext()) {
            dexField = iterator.next().getField(fieldKey);
            if (dexField == null || !dexField.isAccessibleTo(this.getDefining())) continue;
            return dexField;
        }
        return null;
    }

    public DexField getDeclaredField(FieldKey fieldKey) {
        Iterator<DexField> iterator = this.getDeclaredFields();
        while (iterator.hasNext()) {
            DexField dexField = iterator.next();
            if (!fieldKey.equalsIgnoreDeclaring(dexField.getKey())) continue;
            return dexField;
        }
        return null;
    }

    public DexMethod getMethod(MethodKey methodKey) {
        DexMethod dexMethod = this.getDeclaredMethod(methodKey);
        if (dexMethod != null) {
            return dexMethod;
        }
        Iterator<DexClass> iterator = this.getSuperTypes();
        while (iterator.hasNext()) {
            DexClass dexClass = iterator.next();
            dexMethod = dexClass.getDeclaredMethod(methodKey);
            if (dexMethod == null || !dexMethod.isAccessibleTo(methodKey.getDeclaring())) continue;
            return dexMethod;
        }
        return null;
    }

    public Iterator<DexMethod> getMethods(MethodKey methodKey) {
        return this.getMethods(methodKey, false);
    }

    public Iterator<DexMethod> getMethods(MethodKey methodKey, boolean ignoreAccessibility) {
        TypeKey declaring = this.getKey();
        return CombiningIterator.two(this.getDeclaredMethods(methodKey), ComputeIterator.of(this.getSuperTypes(), dexClass -> {
            DexMethod method = dexClass.getDeclaredMethod(methodKey);
            if (method != null && !method.isPrivate() && (ignoreAccessibility || method.isAccessibleTo(declaring))) {
                return method;
            }
            return null;
        }));
    }

    public Iterator<DexMethod> getExtending(MethodKey methodKey) {
        return CombiningIterator.of(this.getDeclaredMethod(methodKey), ComputeIterator.of(this.getExtending(), dexClass -> dexClass.getExtending(methodKey)));
    }

    public Iterator<DexMethod> getImplementations(MethodKey methodKey) {
        return CombiningIterator.of(this.getDeclaredMethod(methodKey), ComputeIterator.of(this.getImplementations(), dexClass -> dexClass.getImplementations(methodKey)));
    }

    public Iterator<MethodKey> getOverridingKeys(MethodKey methodKey) {
        MethodKey key = methodKey.changeDeclaring(this.getKey());
        return CombiningIterator.of(CombiningIterator.singleOne(key, SingleIterator.of(this.getBridging(methodKey))), ComputeIterator.of(this.getOverriding(), dexClass -> dexClass.getOverridingKeys(key)));
    }

    private MethodKey getBridging(MethodKey methodKey) {
        DexMethod dexMethod = this.getDeclaredMethod(methodKey, false);
        if (dexMethod != null) {
            return dexMethod.getBridging();
        }
        return null;
    }

    public boolean containsDeclaredMethod(MethodKey methodKey) {
        if (methodKey == null) {
            return false;
        }
        ClassData classData = this.getClassData();
        if (classData == null) {
            return false;
        }
        return classData.getMethod(methodKey) != null;
    }

    public DexMethod getDeclaredMethod(MethodKey methodKey) {
        return this.getDeclaredMethod(methodKey, false);
    }

    public DexMethod getDeclaredMethod(MethodKey methodKey, boolean ignoreReturnType) {
        Iterator<DexMethod> iterator = this.getDeclaredMethods();
        while (iterator.hasNext()) {
            DexMethod dexMethod = iterator.next();
            MethodKey key = dexMethod.getKey();
            if (!methodKey.equalsNameAndParameters(key) || !ignoreReturnType && !methodKey.equalsReturnType(key)) continue;
            return dexMethod;
        }
        return null;
    }

    public Iterator<DexMethod> getDeclaredMethods(MethodKey methodKey) {
        return FilterIterator.of(this.getDeclaredMethods(), dexMethod -> methodKey.equalsNameAndParameters(dexMethod.getKey()));
    }

    public Iterator<DexClass> getOverridingAndSuperTypes() {
        return CombiningIterator.two(this.getOverriding(), this.getSuperTypes());
    }

    public Iterator<DexClass> getSuperTypes() {
        IterableIterator<DexClass, DexClass> iterator = CombiningIterator.two(SingleIterator.of(this.getSuperClass()), this.getInterfaceClasses());
        iterator = new IterableIterator<DexClass, DexClass>(iterator){

            @Override
            public Iterator<DexClass> iterator(DexClass element) {
                return CombiningIterator.two(SingleIterator.of(element), element.getSuperTypes());
            }
        };
        return new UniqueIterator<DexClass>((Iterator<DexClass>)iterator).exclude(this);
    }

    public Iterator<DexClass> getOverriding() {
        return CombiningIterator.two(this.getExtending(), this.getImplementations());
    }

    public Iterator<DexClass> getExtending() {
        return this.getDexLayout().searchExtending(this.getKey());
    }

    public Iterator<DexClass> getImplementations() {
        return this.getDexLayout().searchImplementations(this.getKey());
    }

    public DexClass getSuperClass() {
        return this.search(this.getSuperClassKey());
    }

    public boolean isInstance(TypeKey typeKey) {
        if (typeKey == null) {
            return false;
        }
        if (typeKey.equals(TypeKey.OBJECT)) {
            return true;
        }
        TypeKey superType = this.getSuperClassKey();
        if (typeKey.equals(this.getKey()) || typeKey.equals(superType)) {
            return true;
        }
        DexClass superClass = this.search(superType);
        if (superClass != null && superClass.isInstance(typeKey) && superClass.isInstance(typeKey)) {
            return true;
        }
        TypeListKey typeListKey = this.getInterfacesKey();
        if (typeListKey.contains(typeKey)) {
            return true;
        }
        if (superClass == null && ReflectionUtil.isInstanceReflection(superType, typeKey)) {
            return true;
        }
        for (TypeKey key : typeListKey) {
            DexClass dexClass = this.search(key);
            if (!(dexClass != null ? dexClass.isInstance(typeKey) : ReflectionUtil.isInstanceReflection(key, typeKey))) continue;
            return true;
        }
        return false;
    }

    public Iterator<DexField> getDeclaredFields() {
        return CombiningIterator.two(this.getStaticFields(), this.getInstanceFields());
    }

    public DexField getOrCreateStaticField(FieldKey fieldKey) {
        return this.initializeField(this.getOrCreateStatic(fieldKey));
    }

    public FieldDef getOrCreateStatic(FieldKey fieldKey) {
        return this.getOrCreateClassData().getOrCreateStatic(fieldKey);
    }

    public Iterator<DexField> getStaticFields() {
        return ComputeIterator.of(this.getId().getStaticFields(), this::initializeField);
    }

    public Iterator<DexField> getInstanceFields() {
        return ComputeIterator.of(this.getId().getInstanceFields(), this::initializeField);
    }

    public DexField getOrCreateInstanceField(FieldKey fieldKey) {
        return this.initializeField(this.getOrCreateInstance(fieldKey));
    }

    public FieldDef getOrCreateInstance(FieldKey fieldKey) {
        return this.getOrCreateClassData().getOrCreateInstance(fieldKey);
    }

    public Iterator<DexMethod> getDeclaredMethods(Predicate<DexMethod> filter) {
        Iterator<DexMethod> iterator = this.getDeclaredMethods();
        if (filter == null) {
            return iterator;
        }
        return FilterIterator.of(iterator, filter);
    }

    public Iterator<DexMethod> getDeclaredMethods() {
        return CombiningIterator.two(this.getDirectMethods(), this.getVirtualMethods());
    }

    public Iterator<DexMethod> getDirectMethods() {
        return ComputeIterator.of(this.getId().getDirectMethods(), this::initializeMethod);
    }

    public Iterator<DexMethod> getVirtualMethods() {
        return ComputeIterator.of(this.getId().getVirtualMethods(), this::initializeMethod);
    }

    public DexMethod getOrCreateDirectMethod(MethodKey methodKey) {
        return this.initializeMethod(this.getOrCreateClassData().getOrCreateDirect(methodKey));
    }

    public DexMethod getOrCreateVirtualMethod(MethodKey methodKey) {
        return this.initializeMethod(this.getOrCreateClassData().getOrCreateVirtual(methodKey));
    }

    public DexMethod getOrCreateStaticMethod(MethodKey methodKey) {
        DexMethod dexMethod = this.getOrCreateDirectMethod(methodKey);
        dexMethod.addAccessFlag(AccessFlag.STATIC);
        return dexMethod;
    }

    DexField initializeField(FieldDef fieldDef) {
        return new DexField(this, fieldDef);
    }

    DexMethod initializeMethod(MethodDef methodDef) {
        return new DexMethod(this, methodDef);
    }

    public Iterator<DexInstruction> getDexInstructions() {
        return this.getDexInstructions(null);
    }

    public Iterator<DexInstruction> getDexInstructions(Predicate<DexMethod> filter) {
        return new IterableIterator<DexMethod, DexInstruction>(this.getDeclaredMethods(filter)){

            @Override
            public Iterator<DexInstruction> iterator(DexMethod element) {
                return element.getInstructions();
            }
        };
    }

    public void decode(SmaliWriter writer, File outDir) throws IOException {
        File file = new File(outDir, this.toFilePath());
        File dir = file.getParentFile();
        if (dir != null && !dir.exists() && !dir.mkdirs()) {
            throw new IOException("Failed to create dir: " + dir);
        }
        FileOutputStream outputStream = new FileOutputStream(file);
        writer.setWriter(new OutputStreamWriter(outputStream));
        this.append(writer);
        writer.close();
        outputStream.close();
    }

    private String toFilePath() {
        String name = this.getDefining().getTypeName();
        name = name.substring(1, name.length() - 1);
        name = name.replace('/', File.separatorChar);
        return name + ".smali";
    }

    @Override
    public DexLayout getDexLayout() {
        return this.dexLayout;
    }

    @Override
    public ClassId getId() {
        return this.classId;
    }

    @Override
    public DexClass getDexClass() {
        return this;
    }

    @Override
    public TypeKey getKey() {
        return this.getId().getKey();
    }

    public ClassId getDefinition() {
        return this.getId();
    }

    @Override
    public TypeKey getSuperClassKey() {
        return this.getId().getSuperClassKey();
    }

    public void setSuperClass(TypeKey superClass) {
        this.getId().setSuperClass(superClass);
    }

    @Override
    public String getSourceFileName() {
        return this.getId().getSourceFileName();
    }

    public void setSourceFile(String sourceFile) {
        this.getId().setSourceFile(sourceFile);
    }

    public Iterator<DexClass> getInterfaceClasses() {
        return ComputeIterator.of(this.getInterfacesKey().iterator(), this::search);
    }

    DexClass search(TypeKey typeKey) {
        return this.getClassRepository().getDexClass(typeKey);
    }

    public boolean containsInterface(TypeKey typeKey) {
        return this.getInterfacesKey().contains(typeKey);
    }

    @Override
    public TypeListKey getInterfacesKey() {
        return this.getId().getInterfacesKey();
    }

    public void addInterface(TypeKey typeKey) {
        TypeListKey typeListKey = this.getInterfacesKey().remove(typeKey).add(typeKey);
        this.getId().setInterfaces(typeListKey);
    }

    public void removeInterface(TypeKey typeKey) {
        TypeListKey typeListKey = this.getInterfacesKey().remove(typeKey);
        this.getId().setInterfaces(typeListKey);
    }

    public void clearInterfaces() {
        this.getId().setInterfaces(TypeListKey.empty());
    }

    public void clearDebug() {
        Iterator<DexMethod> iterator = this.getDeclaredMethods();
        while (iterator.hasNext()) {
            iterator.next().clearDebug();
        }
    }

    public void fixDalvikInnerClassName() {
        String inner;
        DalvikInnerClass dalvikInnerClass = DalvikInnerClass.of(this);
        if (dalvikInnerClass != null && dalvikInnerClass.hasName() && (inner = this.getKey().getSimpleInnerName()) != null) {
            dalvikInnerClass.setName(inner);
        }
    }

    public Set<Key> fixAccessibility() {
        DexClassRepository repository = this.getClassRepository();
        HashSet<Key> results = new HashSet<Key>();
        Iterator<Key> iterator = this.getId().usedKeys();
        while (iterator.hasNext()) {
            Key key = iterator.next();
            if (results.contains(key) || !this.fixAccessibility(repository.getDexDeclaration(key))) continue;
            results.add(key);
        }
        this.fixMethodAccessibility(results);
        return results;
    }

    private void fixMethodAccessibility(Set<Key> results) {
        Iterator<DexMethod> iterator = this.getDeclaredMethods();
        while (iterator.hasNext()) {
            DexMethod dexMethod = iterator.next();
            if (dexMethod.isPrivate()) continue;
            Iterator<DexMethod> superMethods = this.getMethods(dexMethod.getKey(), true);
            while (superMethods.hasNext()) {
                DexMethod method = superMethods.next();
                if (!this.fixAccessibility(method)) continue;
                results.add(method.getKey());
            }
            Iterator<DexMethod> extendingMethods = this.getExtending(dexMethod.getKey());
            while (superMethods.hasNext()) {
                DexMethod method = extendingMethods.next();
                MethodKey key = method.getKey();
                if (results.contains(key) || !this.fixAccessibility(method)) continue;
                results.add(key);
            }
        }
    }

    private boolean fixAccessibility(DexDeclaration declaration) {
        if (declaration == null || declaration.isPrivate() || declaration.hasAccessFlag(AccessFlag.CONSTRUCTOR, AccessFlag.STATIC)) {
            return false;
        }
        if (!declaration.isAccessibleTo(this)) {
            declaration.addAccessFlag(AccessFlag.PUBLIC);
            return true;
        }
        return false;
    }

    public TypeKey getDalvikEnclosingClass() {
        TypeKey key = this.getId().getDalvikEnclosing();
        if (key != null) {
            return key.getDeclaring();
        }
        return null;
    }

    public String getDalvikInnerClassName() {
        DalvikInnerClass dalvikInnerClass = DalvikInnerClass.of(this);
        if (dalvikInnerClass != null) {
            return dalvikInnerClass.getName();
        }
        return null;
    }

    public void updateDalvikInnerClassName(String name) {
        DalvikInnerClass dalvikInnerClass = DalvikInnerClass.of(this);
        if (dalvikInnerClass != null) {
            dalvikInnerClass.setName(name);
        }
    }

    public void createDalvikInnerClassName(String name) {
        DalvikInnerClass.getOrCreate(this).setName(name);
    }

    ClassData getOrCreateClassData() {
        return this.getId().getOrCreateClassData();
    }

    ClassData getClassData() {
        return this.getId().getClassData();
    }

    @Override
    public void removeSelf() {
        this.getDefinition().removeSelf();
    }

    public void edit() {
        this.getId().edit();
    }

    @Override
    public int compareTo(DexClass dexClass) {
        return this.getKey().compareTo(dexClass.getKey());
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getClassData();
        this.getId().append(writer);
    }

    public DexMethod parseMethod(SmaliReader reader) throws IOException {
        SmaliMethod smaliMethod = new SmaliMethod();
        smaliMethod.setDefining(this.getKey());
        smaliMethod.parse(reader);
        MethodKey methodKey = smaliMethod.getKey();
        DexMethod dexMethod = smaliMethod.isDirect() ? this.getOrCreateDirectMethod(methodKey) : this.getOrCreateVirtualMethod(methodKey);
        dexMethod.getDefinition().fromSmali(smaliMethod);
        return dexMethod;
    }

    public DexField parseField(SmaliReader reader) throws IOException {
        SmaliField smaliField = new SmaliField();
        smaliField.setDefining(this.getKey());
        smaliField.parse(reader);
        FieldKey fieldKey = smaliField.getKey();
        DexField dexField = smaliField.isInstance() ? this.getOrCreateInstanceField(fieldKey) : this.getOrCreateStaticField(fieldKey);
        dexField.getDefinition().fromSmali(smaliField);
        return dexField;
    }

    public DexField parseInterfaces(SmaliReader reader) throws IOException {
        SmaliField smaliField = new SmaliField();
        smaliField.setDefining(this.getKey());
        smaliField.parse(reader);
        FieldKey fieldKey = smaliField.getKey();
        DexField dexField = smaliField.isInstance() ? this.getOrCreateInstanceField(fieldKey) : this.getOrCreateStaticField(fieldKey);
        dexField.getDefinition().fromSmali(smaliField);
        return dexField;
    }

    public void writeSmali(SmaliWriter writer, File dir) throws IOException {
        File file = writer.getFileNameFactory().toFile(dir, this.getKey());
        FileUtil.ensureParentDirectory(file);
        FileWriter fileWriter = new FileWriter(file);
        writer.setWriter(fileWriter);
        this.append(writer);
        writer.close();
    }

    public String toSmali() throws IOException {
        return SmaliWriter.toString(this);
    }

    public String toSmali(SmaliWriter writer) throws IOException {
        return SmaliWriter.toString(writer, this);
    }

    @Override
    public int hashCode() {
        return this.getKey().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexClass dexClass = (DexClass)obj;
        if (!this.isInSameFile(dexClass)) {
            return false;
        }
        return this.getKey().equals(dexClass.getKey());
    }

    @Override
    public String toString() {
        return SmaliWriter.toStringSafe(this);
    }
}

