/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.base.BlockRefresh;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.common.FullRefresh;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.data.CodeItem;
import com.reandroid.dex.data.DebugInfo;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.id.SourceFile;
import com.reandroid.dex.key.CallSiteKey;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.MethodHandleKey;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.key.ProtoKey;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.key.TypeKeyReference;
import com.reandroid.dex.key.TypeListKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassModule;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexField;
import com.reandroid.dex.model.DexIntegerVisitor;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.CombiningIterator;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.utils.collection.UniqueIterator;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public interface DexClassRepository
extends FullRefresh,
BlockRefresh {
    public Iterator<DexClassModule> modules();

    public DexClassRepository getRootRepository();

    default public int getVersion() {
        int version = 0;
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            int v = iterator.next().getVersion();
            if (v <= version) continue;
            version = v;
        }
        return version;
    }

    default public void setVersion(int version) {
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            iterator.next().setVersion(version);
        }
    }

    default public int getCount(SectionType<?> sectionType) {
        int result = 0;
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            result += iterator.next().getCount(sectionType);
        }
        return result;
    }

    default public int getDexClassesCount() {
        return this.getCount(SectionType.CLASS_ID);
    }

    default public int shrink() {
        int result = 0;
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            result += iterator.next().shrink();
        }
        return result;
    }

    default public DexClass getDexClass(TypeKey typeKey) {
        return this.searchClass(this.modules(), typeKey);
    }

    default public DexClass searchClass(TypeKey typeKey) {
        return this.searchClass(this.getRootRepository().modules(), typeKey);
    }

    default public DexClass searchClass(Iterator<DexClassModule> modules, TypeKey typeKey) {
        while (modules.hasNext()) {
            DexClass dexClass = modules.next().getDexClass(typeKey);
            if (dexClass == null) continue;
            return dexClass;
        }
        return null;
    }

    default public Iterator<DexClass> getDexClasses(final Predicate<? super TypeKey> filter) {
        return new IterableIterator<DexClassModule, DexClass>(this.modules()){

            @Override
            public Iterator<DexClass> iterator(DexClassModule element) {
                return element.getDexClasses(filter);
            }
        };
    }

    default public Iterator<DexClass> getDexClassesCloned(final Predicate<? super TypeKey> filter) {
        return new IterableIterator<DexClassModule, DexClass>(this.modules()){

            @Override
            public Iterator<DexClass> iterator(DexClassModule element) {
                return element.getDexClassesCloned(filter);
            }
        };
    }

    default public Iterator<DexClass> searchExtending(final TypeKey typeKey) {
        UniqueIterator<DexClass> iterator = new UniqueIterator<DexClass>((Iterator<DexClass>)new IterableIterator<DexClassModule, DexClass>(this.getRootRepository().modules()){

            @Override
            public Iterator<DexClass> iterator(DexClassModule element) {
                return element.getExtendingClasses(typeKey);
            }
        });
        iterator.exclude(this.getDexClass(typeKey));
        return iterator;
    }

    default public Iterator<DexClass> searchImplementations(final TypeKey typeKey) {
        UniqueIterator<DexClass> iterator = new UniqueIterator<DexClass>((Iterator<DexClass>)new IterableIterator<DexClassModule, DexClass>(this.getRootRepository().modules()){

            @Override
            public Iterator<DexClass> iterator(DexClassModule element) {
                return element.getImplementClasses(typeKey);
            }
        });
        iterator.exclude(this.getDexClass(typeKey));
        return iterator;
    }

    default public <T extends SectionItem> Iterator<Section<T>> getSections(final SectionType<T> sectionType) {
        return new IterableIterator<DexClassModule, Section<T>>(this.modules()){

            @Override
            public Iterator<Section<T>> iterator(DexClassModule element) {
                return element.getSections(sectionType);
            }
        };
    }

    default public <T extends SectionItem> Iterator<T> getItems(SectionType<T> sectionType) {
        return new IterableIterator<Section<T>, T>(this.getSections(sectionType)){

            @Override
            public Iterator<T> iterator(Section<T> element) {
                return element.iterator();
            }
        };
    }

    default public <T extends SectionItem> Iterator<T> getClonedItems(SectionType<T> sectionType) {
        return new IterableIterator<Section<T>, T>(this.getSections(sectionType)){

            @Override
            public Iterator<T> iterator(Section<T> element) {
                return element.clonedIterator();
            }
        };
    }

    default public <T extends SectionItem> Iterator<T> getClonedItemsIf(SectionType<T> sectionType, Predicate<? super T> predicate) {
        return FilterIterator.of(this.getClonedItems(sectionType), predicate);
    }

    default public <T extends SectionItem> Iterator<T> getClonedItemsIfKey(SectionType<T> sectionType, Predicate<? super Key> predicate) {
        if (predicate == null) {
            return this.getClonedItems(sectionType);
        }
        return this.getClonedItemsIf(sectionType, item -> predicate.test(item.getKey()));
    }

    default public <T extends SectionItem> Iterator<T> getItems(SectionType<T> sectionType, final Key key) {
        return new IterableIterator<Section<T>, T>(this.getSections(sectionType)){

            @Override
            public Iterator<T> iterator(Section<T> element) {
                return element.getAll(key);
            }
        };
    }

    default public <T extends SectionItem> Iterator<T> getItemsIf(SectionType<T> sectionType, final Predicate<? super T> predicate) {
        return new IterableIterator<Section<T>, T>(this.getSections(sectionType)){

            @Override
            public Iterator<T> iterator(Section<T> element) {
                return element.iterator(predicate);
            }
        };
    }

    default public <T extends SectionItem> Iterator<T> getItemsIfKey(SectionType<T> sectionType, Predicate<? super Key> predicate) {
        if (predicate == null) {
            return this.getItems(sectionType);
        }
        return this.getItemsIf(sectionType, item -> predicate.test(item.getKey()));
    }

    default public <T extends SectionItem> T getItem(SectionType<T> sectionType, int id) {
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            T item = iterator.next().getItem(sectionType, id);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    default public <T extends SectionItem> T getItem(SectionType<T> sectionType, Key key) {
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            T item = iterator.next().getItem(sectionType, key);
            if (item == null) continue;
            return item;
        }
        return null;
    }

    default public boolean contains(SectionType<?> sectionType, Key key) {
        return this.getItems(sectionType, key).hasNext();
    }

    default public boolean contains(Key key) {
        if (key == null) {
            return false;
        }
        if (key instanceof StringKey) {
            return this.contains(SectionType.STRING_ID, key);
        }
        if (key instanceof TypeKey) {
            return this.contains(SectionType.TYPE_ID, key);
        }
        if (key instanceof FieldKey) {
            return this.contains(SectionType.FIELD_ID, key);
        }
        if (key instanceof ProtoKey) {
            return this.contains(SectionType.PROTO_ID, key);
        }
        if (key instanceof MethodKey) {
            return this.contains(SectionType.METHOD_ID, key);
        }
        if (key instanceof TypeListKey) {
            return this.contains(SectionType.TYPE_LIST, key);
        }
        if (key instanceof MethodHandleKey) {
            return this.contains(SectionType.METHOD_HANDLE, key);
        }
        if (key instanceof CallSiteKey) {
            return this.contains(SectionType.CALL_SITE_ID, key);
        }
        throw new IllegalArgumentException("Unknown key type: " + key.getClass() + ", '" + key + "'");
    }

    default public boolean containsClass(TypeKey key) {
        return this.contains(SectionType.CLASS_ID, key);
    }

    default public <T1 extends SectionItem> boolean removeEntries(SectionType<T1> sectionType, Predicate<T1> filter) {
        Iterator<DexClassModule> iterator = this.modules();
        boolean result = false;
        while (iterator.hasNext()) {
            DexClassModule module = iterator.next();
            if (!module.removeEntries(sectionType, filter)) continue;
            result = true;
        }
        return result;
    }

    default public <T1 extends SectionItem> boolean removeEntriesWithKey(SectionType<T1> sectionType, Predicate<? super Key> filter) {
        Iterator<DexClassModule> iterator = this.modules();
        boolean result = false;
        while (iterator.hasNext()) {
            DexClassModule module = iterator.next();
            if (!module.removeEntriesWithKey(sectionType, filter)) continue;
            result = true;
        }
        return result;
    }

    default public <T1 extends SectionItem> boolean removeEntry(SectionType<T1> sectionType, Key key) {
        Iterator<DexClassModule> iterator = this.modules();
        boolean result = false;
        while (iterator.hasNext()) {
            DexClassModule module = iterator.next();
            if (!module.removeEntry(sectionType, key)) continue;
            result = true;
        }
        return result;
    }

    default public void clearPoolMap() {
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            iterator.next().clearPoolMap();
        }
    }

    default public boolean sort() {
        boolean sorted = false;
        Iterator<DexClassModule> iterator = this.modules();
        while (iterator.hasNext()) {
            if (!iterator.next().sort()) continue;
            sorted = true;
        }
        return sorted;
    }

    default public Iterator<DexClass> findUserClasses(Key key) {
        return new UniqueIterator<DexClass>(this.getDexClasses(), dexClass -> dexClass.uses(key));
    }

    default public Iterator<DexClass> getDexClasses() {
        return this.getDexClasses(null);
    }

    default public Iterator<DexClass> getDexClassesCloned() {
        return this.getDexClassesCloned(null);
    }

    default public Iterator<DexClass> getPackageClasses(String packageName) {
        return this.getPackageClasses(packageName, true);
    }

    default public Iterator<DexClass> getPackageClasses(String packageName, boolean includeSubPackages) {
        return this.getDexClasses(key -> key.isPackage(packageName, includeSubPackages));
    }

    default public DexMethod getDeclaredMethod(MethodKey methodKey) {
        DexClass dexClass = this.getDexClass(methodKey.getDeclaring());
        if (dexClass != null) {
            DexMethod dexMethod = dexClass.getDeclaredMethod(methodKey, false);
            if (dexMethod == null) {
                dexMethod = dexClass.getDeclaredMethod(methodKey, true);
            }
            return dexMethod;
        }
        return null;
    }

    default public DexMethod getDeclaredMethod(MethodKey methodKey, boolean ignoreReturnType) {
        DexClass dexClass = this.getDexClass(methodKey.getDeclaring());
        if (dexClass != null) {
            return dexClass.getDeclaredMethod(methodKey, ignoreReturnType);
        }
        return null;
    }

    default public DexField getDeclaredField(FieldKey fieldKey) {
        DexClass dexClass = this.getDexClass(fieldKey.getDeclaring());
        if (dexClass != null) {
            return dexClass.getDeclaredField(fieldKey);
        }
        return null;
    }

    default public DexDeclaration getDexDeclaration(Key key) {
        if (key instanceof TypeKey) {
            return this.getDexClass((TypeKey)key);
        }
        if (key instanceof MethodKey) {
            return this.getDeclaredMethod((MethodKey)key);
        }
        if (key instanceof FieldKey) {
            return this.getDeclaredField((FieldKey)key);
        }
        return null;
    }

    default public Iterator<DexMethod> getDeclaredMethods() {
        return new IterableIterator<DexClass, DexMethod>(this.getDexClasses()){

            @Override
            public Iterator<DexMethod> iterator(DexClass dexClass) {
                return dexClass.getDeclaredMethods();
            }
        };
    }

    default public Iterator<DexField> getDeclaredFields() {
        return new IterableIterator<DexClass, DexField>(this.getDexClasses()){

            @Override
            public Iterator<DexField> iterator(DexClass dexClass) {
                return dexClass.getDeclaredFields();
            }
        };
    }

    default public Iterator<IntegerReference> visitIntegers() {
        return new DexIntegerVisitor(this);
    }

    default public boolean removeClass(TypeKey typeKey) {
        return this.removeEntry(SectionType.CLASS_ID, typeKey);
    }

    default public boolean removeClasses(Predicate<? super DexClass> filter) {
        Iterator<DexClassModule> iterator = this.modules();
        boolean result = false;
        while (iterator.hasNext()) {
            DexClassModule module = iterator.next();
            if (!module.removeClasses(filter)) continue;
            result = true;
        }
        return result;
    }

    default public boolean removeClassesWithKeys(Predicate<? super TypeKey> filter) {
        return this.removeEntriesWithKey(SectionType.CLASS_ID, (Predicate)ObjectsUtil.cast(filter));
    }

    default public boolean removeAnnotations(TypeKey typeKey) {
        return this.removeEntries(SectionType.ANNOTATION_ITEM, annotationItem -> typeKey.equals(annotationItem.getType()));
    }

    default public void clearDebug() {
        Iterator<Section<DebugInfo>> iterator = this.getSections(SectionType.DEBUG_INFO);
        while (iterator.hasNext()) {
            iterator.next().removeSelf();
        }
    }

    default public List<TypeKeyReference> getExternalTypeKeyReferenceList() {
        return ArrayCollection.empty();
    }

    default public Iterator<FieldKey> findEquivalentFields(FieldKey fieldKey) {
        DexClass defining = this.getDexClass(fieldKey.getDeclaring());
        if (defining == null) {
            return EmptyIterator.of();
        }
        DexField dexField = defining.getField(fieldKey);
        if (dexField == null) {
            return EmptyIterator.of();
        }
        defining = dexField.getDexClass();
        FieldKey definingKey = dexField.getKey();
        Iterator<FieldKey> subKeys = ComputeIterator.of(this.getSuccessorClasses(defining.getKey()), dexClass -> {
            FieldKey key = definingKey.changeDeclaring(dexClass.getKey());
            DexField field = dexClass.getField(key);
            if (definingKey.equals(field.getKey())) {
                return key;
            }
            return null;
        });
        return CombiningIterator.two(SingleIterator.of(definingKey), subKeys);
    }

    default public Iterator<DexClass> getSuccessorClasses(final TypeKey typeKey) {
        return new IterableIterator<DexClassModule, DexClass>(this.modules()){

            @Override
            public Iterator<DexClass> iterator(DexClassModule element) {
                return element.getSuccessorClasses(typeKey);
            }
        };
    }

    default public Iterator<MethodKey> findEquivalentMethods(MethodKey methodKey) {
        DexClass defining = this.getDexClass(methodKey.getDeclaring());
        if (defining == null) {
            return EmptyIterator.of();
        }
        Iterator<DexMethod> iterator = defining.getMethods(methodKey);
        return new IterableIterator<DexMethod, MethodKey>(iterator){

            @Override
            public Iterator<MethodKey> iterator(DexMethod element) {
                element = element.getDeclared();
                MethodKey definingKey = element.getKey();
                return CombiningIterator.two(SingleIterator.of(definingKey), element.getOverridingKeys());
            }
        };
    }

    default public Iterator<DexMethod> getMethods(MethodKey methodKey) {
        return ComputeIterator.of(this.findEquivalentMethods(methodKey), this::getDeclaredMethod);
    }

    default public Iterator<MethodId> getMethodIds(MethodKey methodKey) {
        return new IterableIterator<MethodKey, MethodId>(this.findEquivalentMethods(methodKey)){

            @Override
            public Iterator<MethodId> iterator(MethodKey element) {
                return DexClassRepository.this.getItems(SectionType.METHOD_ID, element);
            }
        };
    }

    default public Iterator<Marker> getMarkers() {
        return new IterableIterator<DexClassModule, Marker>(this.modules()){

            @Override
            public Iterator<Marker> iterator(DexClassModule element) {
                return element.getMarkers();
            }
        };
    }

    default public void clearMarkers() {
        Iterator<Marker> iterator = this.getMarkers();
        while (iterator.hasNext()) {
            iterator.next().removeSelf();
        }
    }

    default public void setClassSourceFileAll() {
        this.setClassSourceFileAll(SourceFile.SourceFile);
    }

    default public void setClassSourceFileAll(String sourceFile) {
        Iterator<ClassId> iterator = this.getItems(SectionType.CLASS_ID);
        while (iterator.hasNext()) {
            ClassId classId = iterator.next();
            classId.setSourceFile(sourceFile);
        }
    }

    default public void edit() {
        CollectionUtil.walk(FilterIterator.of(this.getItems(SectionType.CODE), CodeItem::flattenTryItems));
        Iterator<DexClass> iterator = this.getDexClasses();
        while (iterator.hasNext()) {
            iterator.next().edit();
        }
    }
}

