/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.data.FieldDef;
import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexDeclaration;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.program.FieldProgram;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;
import java.util.Iterator;

public class DexField
extends DexDeclaration
implements FieldProgram {
    private final DexClass dexClass;
    private final FieldDef fieldDef;

    public DexField(DexClass dexClass, FieldDef fieldDef) {
        this.dexClass = dexClass;
        this.fieldDef = fieldDef;
    }

    public String getName() {
        return this.getId().getName();
    }

    public void setName(String name) {
        this.getId().setName(name);
    }

    @Override
    public Key getStaticValue() {
        return this.getDefinition().getStaticValue();
    }

    public void setStaticValue(Key value) {
        this.getDefinition().setStaticValue(value);
    }

    public IntegerReference getStaticValueIntegerReference() {
        if (!(this.getStaticValue() instanceof PrimitiveKey.IntegerKey)) {
            return null;
        }
        final DexField dexField = this;
        return new IntegerReference(){

            @Override
            public int get() {
                Key key = dexField.getStaticValue();
                if (key instanceof PrimitiveKey.IntegerKey) {
                    return ((PrimitiveKey.IntegerKey)key).value();
                }
                return 0;
            }

            @Override
            public void set(int value) {
                dexField.setStaticValue(PrimitiveKey.of(value));
            }

            public String toString() {
                return Integer.toString(this.get());
            }
        };
    }

    public IntegerReference getStaticIntegerValue() {
        if (this.isStatic()) {
            IntegerReference reference = this.resolveValueFromStaticConstructor();
            if (reference == null) {
                reference = this.getStaticValueIntegerReference();
            }
            return reference;
        }
        return null;
    }

    private IntegerReference resolveValueFromStaticConstructor() {
        DexClass dexClass = this.getDexClass();
        DexMethod dexMethod = dexClass.getStaticConstructor();
        if (dexMethod == null) {
            return null;
        }
        Iterator<DexInstruction> iterator = dexMethod.getInstructions();
        FieldKey fieldKey = this.getKey();
        while (iterator.hasNext()) {
            DexInstruction instruction = iterator.next();
            if (!fieldKey.equals(instruction.getKeyAsField())) continue;
            if (!instruction.is(Opcode.SPUT)) {
                return null;
            }
            DexInstruction constInstruction = instruction.getPreviousSetter(instruction.getRegister());
            if (constInstruction == null) {
                return null;
            }
            return constInstruction.getAsIntegerReference();
        }
        return null;
    }

    @Override
    public FieldKey getKey() {
        return this.getId().getKey();
    }

    @Override
    public FieldId getId() {
        return (FieldId)this.getDefinition().getId();
    }

    @Override
    public DexClass getDexClass() {
        return this.dexClass;
    }

    public FieldDef getDefinition() {
        return this.fieldDef;
    }

    @Override
    public void removeSelf() {
        this.getDefinition().removeSelf();
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        this.getDefinition().append(writer);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DexField dexField = (DexField)obj;
        return FieldId.equals(this.getId(), dexField.getId());
    }
}

