/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.common.Origin;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.id.StringId;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassModule;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexInstruction;
import com.reandroid.dex.model.DexMergeOptions;
import com.reandroid.dex.model.DexSectionInfo;
import com.reandroid.dex.sections.DexContainerBlock;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.dex.sections.MapItem;
import com.reandroid.dex.sections.MapList;
import com.reandroid.dex.sections.Marker;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.Section;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliClass;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.CollectionUtil;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.SingleIterator;
import com.reandroid.utils.io.FileByteSource;
import com.reandroid.utils.io.FileIterator;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class DexLayout
implements DexClassModule,
Closeable,
Iterable<DexClass> {
    private final DexFile dexFile;
    private final DexLayoutBlock dexLayoutBlock;
    private boolean closed;
    public static final String DIRECTORY_PREFIX = ObjectsUtil.of("layout.");

    public DexLayout(DexFile dexFile, DexLayoutBlock dexLayoutBlock) {
        this.dexFile = dexFile;
        this.dexLayoutBlock = dexLayoutBlock;
        dexLayoutBlock.setTag(this);
    }

    @Override
    public boolean isMultiLayoutEntry() {
        DexContainerBlock containerBlock = this.getDexLayoutBlock().getDexContainerBlock();
        if (containerBlock != null) {
            return containerBlock.isMultiLayout();
        }
        return false;
    }

    @Override
    public int getOffset() {
        return this.getDexLayoutBlock().getHeader().getOffset();
    }

    @Override
    public boolean sort() {
        return this.getDexLayoutBlock().sortStrings();
    }

    public String getName() {
        return DIRECTORY_PREFIX + this.getIndex();
    }

    @Override
    public int getVersion() {
        return this.getDexLayoutBlock().getVersion();
    }

    @Override
    public void setVersion(int version) {
        this.getDexLayoutBlock().setVersion(version);
    }

    @Override
    public int shrink() {
        return this.getDexLayoutBlock().getSectionList().shrink();
    }

    public int clearDuplicateData() {
        return this.getDexLayoutBlock().getSectionList().clearDuplicateData();
    }

    public int clearUnused() {
        return this.getDexLayoutBlock().getSectionList().clearUnused();
    }

    public void clearEmptySections() {
        this.getDexLayoutBlock().clearEmptySections();
    }

    public DexClassRepository getClassRepository() {
        return this.getDexFile();
    }

    public int getIndex() {
        return this.getDexLayoutBlock().getIndex();
    }

    public DexFile getDexFile() {
        return this.dexFile;
    }

    @Override
    public Iterator<DexClass> getExtendingClasses(TypeKey typeKey) {
        return ComputeIterator.of(this.getDexLayoutBlock().getExtendingClassIds(typeKey), this::create);
    }

    @Override
    public Iterator<DexClass> getImplementClasses(TypeKey typeKey) {
        return ComputeIterator.of(this.getDexLayoutBlock().getImplementationIds(typeKey), this::create);
    }

    @Override
    public DexClass getOrCreateClass(TypeKey key) {
        DexClass dexClass = this.searchClass(key);
        if (dexClass != null) {
            return dexClass;
        }
        ClassId classId = this.getOrCreateClassId(key);
        return this.create(classId);
    }

    @Override
    public Iterator<DexClassModule> modules() {
        return SingleIterator.of(this);
    }

    @Override
    public Iterator<DexClass> iterator() {
        return this.getDexClasses();
    }

    @Override
    public boolean removeClasses(Predicate<? super DexClass> filter) {
        Predicate<ClassId> classIdFilter = classId -> filter.test(this.create((ClassId)classId));
        return this.getDexLayoutBlock().removeEntries(SectionType.CLASS_ID, classIdFilter);
    }

    @Override
    public <T1 extends SectionItem> boolean removeEntries(SectionType<T1> sectionType, Predicate<T1> filter) {
        return this.getDexLayoutBlock().removeEntries(sectionType, filter);
    }

    @Override
    public <T1 extends SectionItem> boolean removeEntriesWithKey(SectionType<T1> sectionType, Predicate<? super Key> filter) {
        return this.getDexLayoutBlock().removeWithKeys(sectionType, filter);
    }

    @Override
    public <T1 extends SectionItem> boolean removeEntry(SectionType<T1> sectionType, Key key) {
        return this.getDexLayoutBlock().removeWithKey(sectionType, key);
    }

    @Override
    public DexClass getDexClass(TypeKey key) {
        ClassId classId = this.getItem(SectionType.CLASS_ID, key);
        if (classId == null) {
            return null;
        }
        return this.create(classId);
    }

    @Override
    public Iterator<DexClass> getDexClasses(Predicate<? super TypeKey> filter) {
        return ComputeIterator.of(this.getItemsIfKey(SectionType.CLASS_ID, (Predicate)ObjectsUtil.cast(filter)), this::create);
    }

    @Override
    public Iterator<DexClass> getDexClassesCloned(Predicate<? super TypeKey> filter) {
        return ComputeIterator.of(this.getClonedItemsIfKey(SectionType.CLASS_ID, (Predicate)ObjectsUtil.cast(filter)), this::create);
    }

    @Override
    public DexClassRepository getRootRepository() {
        return this.getDexFile().getRootRepository();
    }

    public ClassId getOrCreateClassId(TypeKey key) {
        Section<ClassId> section = this.getOrCreateSection((SectionType)SectionType.CLASS_ID);
        ClassId classId = section.get(key);
        if (classId != null) {
            return classId;
        }
        classId = section.getOrCreate(key);
        classId.getOrCreateClassData();
        classId.setSuperClass(TypeKey.OBJECT);
        classId.setSourceFile(DexUtils.toSourceFileName(key.getTypeName()));
        classId.addAccessFlag(AccessFlag.PUBLIC);
        return classId;
    }

    private DexClass create(ClassId classId) {
        return new DexClass(this, classId);
    }

    public Marker getOrCreateMarker() {
        Marker marker = CollectionUtil.getFirst(this.getMarkers());
        if (marker != null) {
            return marker;
        }
        marker = Marker.createR8();
        Section<StringId> stringSection = this.getSection((SectionType)SectionType.STRING_ID);
        StringId stringId = stringSection.createItem();
        marker.setStringId(stringId);
        marker.save();
        return marker;
    }

    @Override
    public void addMarker(Marker marker) {
        StringId stringId = marker.getStringId();
        if (stringId == null) {
            Section<StringId> stringSection = this.getSection((SectionType)SectionType.STRING_ID);
            stringId = stringSection.createItem();
            marker.setStringId(stringId);
        }
        marker.save();
    }

    @Override
    public Iterator<Marker> getMarkers() {
        return this.getDexLayoutBlock().getMarkers();
    }

    @Override
    public Iterator<DexSectionInfo> getSectionInfo() {
        MapList mapList = this.getDexLayoutBlock().getMapList();
        return ComputeIterator.of(mapList.iterator(), mapItem -> new DexSectionInfo(this, (MapItem)mapItem));
    }

    @Override
    public void refreshFull() throws DexException {
        this.getDexLayoutBlock().refreshFull();
    }

    public void sortSection(SectionType<?>[] order) {
        this.refresh();
        this.getDexLayoutBlock().sortSection(order);
        this.refresh();
    }

    @Override
    public void clearPoolMap() {
        this.getDexLayoutBlock().clearPoolMap();
    }

    public Iterator<DexInstruction> getDexInstructions() {
        return new IterableIterator<DexClass, DexInstruction>(this.getDexClasses()){

            @Override
            public Iterator<DexInstruction> iterator(DexClass element) {
                return element.getDexInstructions();
            }
        };
    }

    public Iterator<DexInstruction> getDexInstructionsCloned() {
        return new IterableIterator<DexClass, DexInstruction>(this.getDexClassesCloned()){

            @Override
            public Iterator<DexInstruction> iterator(DexClass element) {
                return element.getDexInstructions();
            }
        };
    }

    public <T1 extends SectionItem> Section<T1> getSection(SectionType<T1> sectionType) {
        return this.getDexLayoutBlock().getSection(sectionType);
    }

    public <T1 extends SectionItem> Section<T1> getOrCreateSection(SectionType<T1> sectionType) {
        return this.getDexLayoutBlock().getOrCreateSection(sectionType);
    }

    @Override
    public void refresh() {
        this.getDexLayoutBlock().refresh();
    }

    public DexLayoutBlock getDexLayoutBlock() {
        return this.dexLayoutBlock;
    }

    public boolean isEmpty() {
        return this.getDexLayoutBlock().isEmpty();
    }

    public boolean merge(DexClass dexClass) {
        return this.merge((MergeOptions)new DexMergeOptions(true), dexClass);
    }

    public boolean merge(MergeOptions options, DexClass dexClass) {
        return this.merge(options, dexClass.getId());
    }

    public boolean merge(ClassId classId) {
        return this.merge((MergeOptions)new DexMergeOptions(true), classId);
    }

    public boolean merge(MergeOptions options, ClassId classId) {
        return this.getDexLayoutBlock().merge(options, classId);
    }

    public boolean merge(MergeOptions options, DexLayout dexLayout) {
        if (dexLayout == null || dexLayout.isEmpty()) {
            return false;
        }
        return this.getDexLayoutBlock().merge(options, dexLayout.getDexLayoutBlock());
    }

    public void parseSmaliDirectory(File dir) throws IOException {
        this.requireNotClosed();
        if (!dir.isDirectory()) {
            throw new FileNotFoundException("No such directory: " + dir);
        }
        FileIterator iterator = new FileIterator(dir, FileIterator.getExtensionFilter(".smali"));
        FileByteSource byteSource = new FileByteSource();
        SmaliReader reader = new SmaliReader(byteSource);
        DexLayoutBlock layout = this.getDexLayoutBlock();
        while (iterator.hasNext()) {
            reader.reset();
            File file = iterator.next();
            byteSource.setFile(file);
            reader.setOrigin(Origin.createNew(file));
            SmaliClass smaliClass = new SmaliClass();
            smaliClass.parse(reader);
            layout.fromSmali(smaliClass);
        }
        this.sort();
        this.shrink();
    }

    public void parseSmaliFile(File file) throws IOException {
        this.requireNotClosed();
        this.fromSmali(SmaliReader.of(file));
    }

    public void fromSmaliAll(SmaliReader reader) throws IOException {
        reader.skipWhitespacesOrComment();
        while (!reader.finished()) {
            this.fromSmali(reader);
            reader.skipWhitespacesOrComment();
        }
    }

    public DexClass fromSmali(SmaliReader reader) throws IOException {
        this.requireNotClosed();
        SmaliClass smaliClass = new SmaliClass();
        smaliClass.parse(reader);
        DexClass dexClass = this.fromSmali(smaliClass);
        reader.skipWhitespacesOrComment();
        return dexClass;
    }

    public DexClass fromSmali(SmaliClass smaliClass) throws IOException {
        this.requireNotClosed();
        ClassId classId = this.getDexLayoutBlock().fromSmali(smaliClass);
        return this.create(classId);
    }

    public void writeSmali(SmaliWriter writer, File root) throws IOException {
        Iterator<DexClass> iterator = this.getDexClasses();
        while (iterator.hasNext()) {
            iterator.next().writeSmali(writer, root);
        }
    }

    public byte[] getBytes() {
        if (this.isClosed()) {
            return null;
        }
        if (this.isEmpty()) {
            return new byte[0];
        }
        return this.getDexLayoutBlock().getBytes();
    }

    public String printSectionInfo(boolean hex) {
        StringBuilder builder = new StringBuilder();
        boolean appendOnce = false;
        if (this.isMultiLayoutEntry()) {
            builder.append(this.getName());
            builder.append(", offset = ");
            builder.append(this.getOffset());
            appendOnce = true;
        }
        Iterator<DexSectionInfo> iterator = this.getSectionInfo();
        while (iterator.hasNext()) {
            DexSectionInfo sectionInfo = iterator.next();
            if (appendOnce) {
                builder.append('\n');
            }
            builder.append(' ');
            int index = sectionInfo.getIndex();
            if (index < 10) {
                builder.append(' ');
            }
            builder.append(index);
            builder.append(") ");
            builder.append(sectionInfo.print(hex));
            appendOnce = true;
        }
        return builder.toString();
    }

    private void requireNotClosed() throws IOException {
        if (this.isClosed()) {
            throw new IOException("Closed");
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            this.closed = true;
            this.getDexLayoutBlock().clear();
        }
    }

    public int getDexClassesCountForDebug() {
        Section<ClassId> section = this.getSection((SectionType)SectionType.CLASS_ID);
        if (section != null) {
            return section.getCount();
        }
        DexSectionInfo sectionInfo = this.getSectionInfo(SectionType.CLASS_ID);
        if (sectionInfo != null) {
            return sectionInfo.getCount();
        }
        return 0;
    }

    public String toString() {
        DexSectionInfo sectionInfo;
        StringBuilder builder = new StringBuilder();
        if (this.isMultiLayoutEntry()) {
            builder.append("offset = ");
            builder.append(this.getOffset());
            builder.append(", ");
        }
        builder.append("version = ");
        builder.append(this.getVersion());
        builder.append(", classes = ");
        int classesCount = this.getSections(SectionType.CLASS_ID).hasNext() ? this.getDexClassesCount() : ((sectionInfo = this.getSectionInfo(SectionType.CLASS_ID)) != null ? sectionInfo.getCount() : 0);
        builder.append(classesCount);
        return builder.toString();
    }

    public static DexLayout findDexFile(ClassId classId) {
        if (classId == null) {
            return null;
        }
        return DexLayout.findDexFile(classId.getParentInstance(DexLayoutBlock.class));
    }

    public static DexLayout findDexFile(DexLayoutBlock dexLayoutBlock) {
        if (dexLayoutBlock == null) {
            return null;
        }
        Object obj = dexLayoutBlock.getTag();
        if (!(obj instanceof DexLayout)) {
            return null;
        }
        return (DexLayout)obj;
    }
}

