/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.model;

import com.reandroid.dex.id.ClassId;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexDirectory;
import com.reandroid.dex.model.DexFile;
import com.reandroid.dex.model.DexLayout;
import com.reandroid.dex.sections.DexLayoutBlock;
import com.reandroid.dex.sections.MergeOptions;
import com.reandroid.dex.sections.SectionList;
import java.util.HashSet;
import java.util.Set;

public class DexMergeOptions
implements MergeOptions {
    private final boolean relocate;
    private final Set<TypeKey> mergedSet;
    private int mergeStartDexFile;

    public DexMergeOptions(boolean relocate) {
        this.relocate = relocate;
        this.mergedSet = new HashSet<TypeKey>();
    }

    public DexMergeOptions() {
        this(true);
    }

    @Override
    public boolean skipMerging(ClassId classId, TypeKey typeKey) {
        return this.mergedSet.contains(typeKey);
    }

    @Override
    public void onDuplicate(ClassId classId) {
        if (this.relocate) {
            classId.removeSelf();
        }
        this.mergedSet.add(classId.getKey());
    }

    @Override
    public void onMergeError(DexLayoutBlock dexLayoutBlock, ClassId classId, String message) {
    }

    @Override
    public void onMergeError(DexLayoutBlock dexLayoutBlock, SectionList sectionList, String message) {
    }

    @Override
    public void onDexFull(DexLayoutBlock dexLayoutBlock, ClassId classId) {
        DexLayout coming = DexLayout.findDexFile(classId);
        if (coming == null) {
            return;
        }
        DexLayout dexLayout = DexLayout.findDexFile(dexLayoutBlock);
        if (dexLayout == null) {
            return;
        }
        DexDirectory directory = dexLayout.getDexFile().getDexDirectory();
        if (directory == null || directory == coming.getDexFile().getDexDirectory()) {
            return;
        }
        this.onCreateNext(dexLayoutBlock);
    }

    @Override
    public void onMergeSuccess(ClassId classId, TypeKey key) {
        if (!this.relocate) {
            this.mergedSet.add(key);
        }
    }

    @Override
    public boolean relocateClass() {
        return this.relocate;
    }

    @Override
    public int getMergeStartDexFile() {
        return this.mergeStartDexFile;
    }

    @Override
    public void setMergeStartDexFile(int mergeStartDexFile) {
        this.mergeStartDexFile = mergeStartDexFile;
    }

    @Override
    public DexLayoutBlock onCreateNext(DexLayoutBlock last) {
        DexLayout dexLayout = DexLayout.findDexFile(last);
        if (dexLayout == null) {
            return null;
        }
        DexDirectory directory = dexLayout.getDexFile().getDexDirectory();
        if (directory == null || directory.getLast() != dexLayout.getDexFile()) {
            return null;
        }
        DexFile dexFile = directory.createDefault();
        this.setMergeStartDexFile(dexFile.getIndex());
        return dexFile.getFirst().getDexLayoutBlock();
    }
}

