/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.program;

import com.reandroid.dex.common.AccessFlag;
import com.reandroid.dex.common.Modifier;
import com.reandroid.dex.program.ProgramElement;
import java.util.Iterator;

public interface AccessibleProgram
extends ProgramElement {
    public int getAccessFlagsValue();

    public void setAccessFlagsValue(int var1);

    default public boolean isPublic() {
        return AccessFlag.PUBLIC.isSet(this.getElementType(), this.getAccessFlagsValue());
    }

    default public boolean isPrivate() {
        return AccessFlag.PRIVATE.isSet(this.getElementType(), this.getAccessFlagsValue());
    }

    default public boolean isInternal() {
        return (this.getAccessFlagsValue() & 7) == 0;
    }

    default public boolean isStatic() {
        return AccessFlag.STATIC.isSet(this.getElementType(), this.getAccessFlagsValue());
    }

    default public boolean isFinal() {
        return AccessFlag.FINAL.isSet(this.getElementType(), this.getAccessFlagsValue());
    }

    default public boolean isProtected() {
        return AccessFlag.PROTECTED.isSet(this.getAccessFlagsValue());
    }

    default public boolean isNative() {
        return AccessFlag.NATIVE.isSet(this.getAccessFlagsValue());
    }

    default public boolean isSynthetic() {
        return AccessFlag.SYNTHETIC.isSet(this.getAccessFlagsValue());
    }

    default public boolean isAbstract() {
        return AccessFlag.ABSTRACT.isSet(this.getAccessFlagsValue());
    }

    default public Iterator<? extends Modifier> getModifiers() {
        return this.getAccessFlags();
    }

    default public void addAccessFlag(AccessFlag flag) {
        int current = this.getAccessFlagsValue();
        int value = flag.getValue();
        if ((value & 7) != 0) {
            current &= 0xFFFFFFF8;
        }
        this.setAccessFlagsValue(current | value);
    }

    default public Iterator<? extends Modifier> getAccessFlags() {
        return AccessFlag.valuesOf(this.getElementType(), this.getAccessFlagsValue());
    }

    default public void removeAccessFlag(AccessFlag flag) {
        this.setAccessFlagsValue(this.getAccessFlagsValue() & ~flag.getValue());
    }
}

