/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.refactor;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.KeyPair;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.StringsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class Rename<T extends Key, R extends Key> {
    private final Map<KeyPair<?, ?>, KeyPair<T, R>> keyPairMap = new HashMap();
    private final Map<KeyPair<?, ?>, KeyPair<T, R>> flippedKeyMap = new HashMap();
    private final Set<KeyPair<?, ?>> lockedKeys = new HashSet();
    private final Set<KeyPair<?, ?>> lockedFlippedKeys = new HashSet();

    public void add(T search, R replace) {
        this.add(new KeyPair<T, R>(search, replace));
    }

    public void add(KeyPair<T, R> keyPair) {
        this.addToSet(keyPair);
    }

    public void addAll(Collection<KeyPair<T, R>> keyPairs) {
        this.addAll(keyPairs.iterator());
    }

    public void addAll(Iterator<KeyPair<T, R>> iterator) {
        while (iterator.hasNext()) {
            this.add(iterator.next());
        }
    }

    private void addToSet(KeyPair<T, R> keyPair) {
        KeyPair<R, T> flip;
        if (keyPair == null || !keyPair.isValid()) {
            return;
        }
        boolean bad = false;
        if (this.lockedKeys.contains(keyPair) || this.lockedFlippedKeys.contains(keyPair)) {
            bad = true;
        }
        if (this.lockedFlippedKeys.contains(flip = keyPair.flip()) || this.lockedKeys.contains(flip)) {
            if (bad) {
                return;
            }
            bad = true;
        }
        if (!bad) {
            KeyPair<T, R> exist = this.keyPairMap.get(keyPair);
            if (exist == null) {
                exist = this.flippedKeyMap.get(flip);
                if (exist != null) {
                    bad = true;
                }
            } else {
                if (keyPair.equalsBoth(exist)) {
                    return;
                }
                bad = true;
            }
        }
        if (bad) {
            this.lockKey(keyPair, flip);
        } else {
            this.keyPairMap.put(keyPair, keyPair);
            this.flippedKeyMap.put(flip, keyPair);
        }
        this.onChanged();
    }

    private void lockKey(KeyPair<T, R> keyPair, KeyPair<R, T> flip) {
        KeyPair<T, R> p2;
        this.lockedKeys.add(keyPair);
        this.lockedFlippedKeys.add(flip);
        KeyPair<T, R> p1 = this.keyPairMap.remove(keyPair);
        if (p1 == null) {
            p1 = this.keyPairMap.remove(flip);
        }
        if ((p2 = this.flippedKeyMap.remove(flip)) == null) {
            p2 = this.flippedKeyMap.remove(keyPair);
        }
        if (p1 != null && !p1.equalsBoth(keyPair)) {
            this.lockKey(p1, p1.flip());
        }
        if (p2 != null && !p2.equalsBoth(keyPair)) {
            this.lockKey(p2, p2.flip());
        }
    }

    public boolean isLocked(KeyPair<T, R> keyPair) {
        if (keyPair != null) {
            KeyPair<R, T> flip = keyPair.flip();
            return this.lockedKeys.contains(keyPair) || this.lockedFlippedKeys.contains(keyPair) || this.lockedKeys.contains(flip) || this.lockedFlippedKeys.contains(flip);
        }
        return false;
    }

    public void lock(KeyPair<T, R> keyPair) {
        if (keyPair != null && keyPair.isValid()) {
            this.lockKey(keyPair, keyPair.flip());
        }
    }

    public void lockAll(Iterable<? extends KeyPair<T, R>> iterable) {
        if (iterable != null) {
            for (KeyPair<T, R> keyPair : iterable) {
                this.lock(keyPair);
            }
        }
    }

    public void unlock(KeyPair<T, R> keyPair) {
        if (keyPair != null) {
            KeyPair<R, T> flip = keyPair.flip();
            this.lockedKeys.remove(keyPair);
            this.lockedFlippedKeys.remove(flip);
            this.add(keyPair);
        }
    }

    protected void onChanged() {
    }

    public void close() {
        this.keyPairMap.clear();
        this.flippedKeyMap.clear();
        this.lockedKeys.clear();
        this.lockedFlippedKeys.clear();
    }

    public int size() {
        return this.keyPairMap.size();
    }

    public KeyPair<T, R> get(Key search) {
        return this.keyPairMap.get(new KeyPair<Key, Object>(search, null));
    }

    public KeyPair<T, R> getFlipped(Key replace) {
        return this.flippedKeyMap.get(new KeyPair<Key, Object>(replace, null));
    }

    public R getReplace(Key search) {
        KeyPair<T, R> keyPair = this.get(search);
        if (keyPair != null) {
            return keyPair.getSecond();
        }
        return null;
    }

    public <E extends Key> E replaceInKey(E key) {
        R replace = this.getReplace((Key)key);
        if (replace != null) {
            if (key.getClass() == replace.getClass()) {
                key = (Key)ObjectsUtil.cast(replace);
            }
            return key;
        }
        Object result = key;
        Iterator<? extends Key> iterator = key.mentionedKeys();
        while (iterator.hasNext()) {
            Key search = iterator.next();
            replace = this.getReplace(search);
            if (replace == null) continue;
            result = result.replaceKey(search, (Key)replace);
        }
        return (E)((Key)ObjectsUtil.cast(result));
    }

    public List<KeyPair<T, R>> toList() {
        return this.toList(CompareUtil.getComparableComparator());
    }

    public List<KeyPair<T, R>> toList(Comparator<KeyPair<? super T, ? super R>> comparator) {
        ArrayCollection<KeyPair<T, R>> results = new ArrayCollection<KeyPair<T, R>>(this.getKeyPairSet());
        if (comparator != null) {
            results.sort(comparator);
        }
        return results;
    }

    public List<KeyPair<T, R>> listLocked() {
        return (List)ObjectsUtil.cast(new ArrayCollection(this.lockedKeys));
    }

    public void validate(DexClassRepository classRepository) {
        List<KeyPair<T, R>> list = this.toList();
        for (KeyPair<T, R> keyPair : list) {
            if (!this.containsDeclaration(classRepository, keyPair.getSecond())) continue;
            this.lock(keyPair);
        }
    }

    protected boolean containsDeclaration(DexClassRepository classRepository, R replaceKey) {
        return classRepository.getDexDeclaration((Key)replaceKey) != null;
    }

    public abstract int apply(DexClassRepository var1);

    public Set<KeyPair<T, R>> getKeyPairSet() {
        return (Set)ObjectsUtil.cast(this.keyPairMap.keySet());
    }

    public String toString() {
        return StringsUtil.join(this.toList(), (Object)Character.valueOf('\n'));
    }
}

