/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.IdReference;
import com.reandroid.dex.sections.SectionType;
import com.reandroid.dex.smali.SmaliFormat;
import com.reandroid.dex.smali.SmaliWriter;
import java.io.IOException;

public class Base1Ule128IdItemReference<T extends IdItem>
extends Ule128Item
implements IdReference<T>,
SmaliFormat {
    private final SectionType<T> sectionType;
    private final int usageType;
    private T item;

    public Base1Ule128IdItemReference(SectionType<T> sectionType, int usageType) {
        this.sectionType = sectionType;
        this.usageType = usageType;
    }

    public Base1Ule128IdItemReference(SectionType<T> sectionType) {
        this(sectionType, UsageMarker.USAGE_DEBUG);
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public void setItem(T item) {
        if (item != null) {
            item = (IdItem)((SectionItem)item).getReplace();
        }
        int index = item != null ? ((IdItem)item).getIdx() + 1 : 0;
        this.item = item;
        this.set(index);
        if (item != null) {
            ((SectionItem)item).addUsageType(UsageMarker.USAGE_DEBUG);
        }
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return ((IdItem)item).getKey();
        }
        return null;
    }

    @Override
    public void setKey(Key key) {
        IdItem item = key != null ? (IdItem)this.getSection(this.getSectionType()).getOrCreate(key) : null;
        this.setItem((T)item);
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public void pullItem() {
        IdItem item;
        int index = this.get();
        if (index == 0) {
            item = null;
        } else {
            item = (IdItem)this.getSectionItem(this.getSectionType(), index - 1);
            this.checkNonNullItem(item, index - 1);
        }
        this.item = item;
        this.updateItemUsage();
    }

    @Override
    public void refresh() {
        SectionItem item = this.getItem();
        if (item != null) {
            item = (IdItem)item.getReplace();
        }
        int idx = 0;
        if (item != null) {
            idx = ((IdItem)item).getIdx() + 1;
        }
        this.item = item;
        this.set(idx);
        this.updateItemUsage();
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.pullItem();
    }

    private void updateItemUsage() {
        T item = this.item;
        if (item != null) {
            ((SectionItem)item).addUsageType(this.usageType);
        }
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        SectionItem item = this.getItem();
        if (item != null) {
            item.append(writer);
        }
    }

    @Override
    public String toString() {
        Key key = this.getKey();
        if (key != null) {
            return key.toString();
        }
        return this.getSectionType().getName() + ": " + (this.get() - 1);
    }
}

