/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.item.IndirectItem;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.DataReference;
import com.reandroid.dex.sections.SectionType;

public class DataItemIndirectReference<T extends DataItem>
extends IndirectItem<SectionItem>
implements DataReference<T> {
    private final SectionType<T> sectionType;
    private final int usageType;
    private T item;

    public DataItemIndirectReference(SectionType<T> sectionType, SectionItem blockItem, int offset, int usageType) {
        super(blockItem, offset);
        this.sectionType = sectionType;
        this.usageType = usageType;
    }

    @Override
    public T getItem() {
        DataItem replace;
        T item = this.item;
        if (item != null && (replace = (DataItem)((SectionItem)item).getReplace()) != item) {
            this.setItem((T)replace);
            item = this.item;
        }
        return item;
    }

    @Override
    public T getOrCreate() {
        SectionItem item = this.getItem();
        if (item != null) {
            return (T)item;
        }
        item = (DataItem)((SectionItem)this.getBlockItem()).createSectionItem(this.getSectionType());
        this.setItem((T)item);
        return (T)item;
    }

    @Override
    public void setItem(T item) {
        if (item == this.item) {
            return;
        }
        int value = 0;
        if (item != null) {
            value = ((SectionItemContainer)item).getIdx();
        }
        this.set(value);
        this.item = item;
        this.updateItemUsage();
    }

    @Override
    public void setKey(Key key) {
        this.setItem((T)((DataItem)((SectionItem)this.getBlockItem()).getOrCreateSectionItem(this.getSectionType(), key)));
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return ((DataItem)item).getKey();
        }
        return null;
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public void pullItem() {
        int i = this.get();
        DataItem item = i == 0 ? null : (DataItem)((SectionItem)this.getBlockItem()).getSectionItem(this.getSectionType(), i);
        this.item = item;
        this.updateItemUsage();
    }

    @Override
    public void refresh() {
        int value = 0;
        SectionItem item = this.getItem();
        if (item != null && (value = ((SectionItemContainer)item).getIdx()) == 0) {
            throw new RuntimeException("Invalid reference");
        }
        this.item = item;
        this.set(value);
        this.updateItemUsage();
    }

    @Override
    public void unlink() {
        this.item = null;
        this.set(0);
    }

    private void updateItemUsage() {
        int usageType = this.usageType;
        if (usageType == UsageMarker.USAGE_NONE) {
            return;
        }
        T item = this.item;
        if (item != null) {
            ((SectionItem)item).addUsageType(usageType);
        }
    }

    public T getUniqueItem(Block user) {
        SectionItem item = this.getItem();
        if (item == null) {
            return null;
        }
        if (((DataItem)item).isSharedItem(user)) {
            item = this.createNewCopy();
        }
        ((DataItem)item).addUniqueUser(user);
        return (T)item;
    }

    public T getOrCreateUniqueItem(Block user) {
        Object item = this.getUniqueItem(user);
        if (item != null) {
            return item;
        }
        item = (DataItem)((SectionItem)this.getBlockItem()).createSectionItem(this.getSectionType());
        this.setItem(item);
        this.addUniqueUser(user);
        return item;
    }

    public void addUniqueUser(Block user) {
        SectionItem item = this.getItem();
        if (item != null) {
            ((DataItem)item).addUniqueUser(user);
        }
    }

    private T createNewCopy() {
        DataItem itemNew = (DataItem)((SectionItem)this.getBlockItem()).createSectionItem(this.getSectionType());
        this.copyToIfPresent(itemNew);
        this.setItem((T)itemNew);
        return (T)itemNew;
    }

    private void copyToIfPresent(T itemNew) {
        SectionItem item = this.getItem();
        if (item != null) {
            ((DataItem)itemNew).copyFrom((DataItem)item);
        }
    }

    @Override
    public void set(int value) {
        Block.putInteger(this.getBytesInternal(), this.getOffset(), value);
    }

    @Override
    public int get() {
        return Block.getInteger(this.getBytesInternal(), this.getOffset());
    }

    public void replaceKeys(Key search, Key replace) {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        Key key2 = key.replaceKey(search, replace);
        if (key != key2) {
            this.setKey(key2);
        }
    }

    @Override
    public void editInternal(Block user) {
        T item = this.getUniqueItem(user);
        if (item != null) {
            ((SectionItem)item).editInternal(user);
        }
    }

    public String toString() {
        if (this.item != null) {
            return this.get() + ":" + this.item.toString();
        }
        return this.getSectionType().getName() + ": " + this.get();
    }
}

