/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.dex.base.Ule128Item;
import com.reandroid.dex.base.UsageMarker;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.DataReference;
import com.reandroid.dex.sections.SectionType;
import java.io.IOException;

public class DataItemUle128Reference<T extends DataItem>
extends Ule128Item
implements DataReference<T> {
    private final SectionType<T> sectionType;
    private T item;
    private final int usageType;

    public DataItemUle128Reference(SectionType<T> sectionType, int usageType) {
        this.sectionType = sectionType;
        this.usageType = usageType;
    }

    @Override
    public T getItem() {
        return this.item;
    }

    @Override
    public T getOrCreate() {
        SectionItem item = this.getItem();
        if (item != null) {
            return (T)item;
        }
        item = (DataItem)this.createSectionItem(this.getSectionType());
        this.setItem((T)item);
        return (T)item;
    }

    @Override
    public void setItem(T item) {
        int offset = 0;
        if (item != null) {
            offset = ((SectionItemContainer)item).getOffset();
        }
        this.item = item;
        this.set(offset);
        this.updateItemUsage();
    }

    @Override
    public void setKey(Key key) {
        this.setItem((T)((DataItem)this.getOrCreateSectionItem(this.getSectionType(), key)));
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return ((DataItem)item).getKey();
        }
        return null;
    }

    @Override
    public void pullItem() {
        this.item = (DataItem)this.getSectionItem(this.getSectionType(), this.get());
        this.updateItemUsage();
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public void refresh() {
        SectionItem item = this.getItem();
        int value = 0;
        if (item != null) {
            item = (DataItem)item.getReplace();
        }
        if (item != null) {
            value = ((SectionItemContainer)item).getIdx();
        }
        this.item = item;
        this.set(value);
        this.updateItemUsage();
    }

    @Override
    public void unlink() {
        this.item = null;
        this.set(0);
    }

    @Override
    public void editInternal(Block user) {
        T item = this.getUniqueItem(user);
        if (item != null) {
            ((SectionItem)item).editInternal(user);
        }
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.pullItem();
    }

    private void updateItemUsage() {
        int usageType = this.usageType;
        if (usageType == UsageMarker.USAGE_NONE) {
            return;
        }
        T item = this.item;
        if (item != null) {
            ((SectionItem)item).addUsageType(usageType);
        }
    }

    public T getUniqueItem(Block user) {
        SectionItem item = this.getItem();
        if (item == null) {
            return null;
        }
        if (((DataItem)item).isSharedItem(user)) {
            item = this.createNewCopy();
        }
        ((DataItem)item).addUniqueUser(user);
        return (T)item;
    }

    public T getOrCreateUniqueItem(Block user) {
        Object item = this.getUniqueItem(user);
        if (item != null) {
            return item;
        }
        item = (DataItem)this.createSectionItem(this.getSectionType());
        this.setItem(item);
        this.addUniqueUser(user);
        return item;
    }

    public void addUniqueUser(Block user) {
        SectionItem item = this.getItem();
        if (item != null) {
            ((DataItem)item).addUniqueUser(user);
        }
    }

    private T createNewCopy() {
        DataItem itemNew = (DataItem)this.createSectionItem(this.getSectionType());
        this.copyToIfPresent(itemNew);
        this.setItem((T)itemNew);
        return (T)itemNew;
    }

    private void copyToIfPresent(T itemNew) {
        SectionItem item = this.getItem();
        if (item != null) {
            ((DataItem)itemNew).copyFrom((DataItem)item);
        }
    }

    @Override
    public String toString() {
        T item = this.item;
        if (item != null) {
            return item.toString();
        }
        return this.sectionType.getName() + ": " + this.get();
    }
}

