/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.reference;

import com.reandroid.arsc.base.Block;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerItem;
import com.reandroid.dex.base.DexException;
import com.reandroid.dex.common.SectionItem;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.common.SectionTool;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.reference.DataReference;
import com.reandroid.dex.sections.SectionType;
import java.io.IOException;

public class IntegerDataReference<T extends DataItem>
extends IntegerItem
implements DataReference<T> {
    private final SectionType<T> sectionType;
    private final int usageType;
    private T item;

    public IntegerDataReference(SectionType<T> sectionType, int usageType) {
        this.sectionType = sectionType;
        this.usageType = usageType;
    }

    @Override
    public T getItem() {
        DataItem replace;
        T item = this.item;
        if (item != null && (replace = (DataItem)((SectionItem)item).getReplace()) != item) {
            this.setItem((T)replace);
            item = this.item;
        }
        return item;
    }

    @Override
    public void setItem(T item) {
        int offset = 0;
        if (item != null) {
            offset = ((SectionItemContainer)item).getOffset();
        }
        this.item = item;
        this.set(offset);
        this.updateItemUsage();
    }

    @Override
    public void setKey(Key key) {
        this.setItem((T)((DataItem)this.getSectionTool().getOrCreateSectionItem(this.getSectionType(), key)));
    }

    @Override
    public Key getKey() {
        SectionItem item = this.getItem();
        if (item != null) {
            return ((DataItem)item).getKey();
        }
        return null;
    }

    @Override
    public SectionType<T> getSectionType() {
        return this.sectionType;
    }

    @Override
    public void pullItem() {
        this.item = (DataItem)this.getSectionTool().getSectionItem(this.getSectionType(), this.get());
        this.updateItemUsage();
    }

    SectionTool getSectionTool() {
        return this.getParentInstance(SectionTool.class);
    }

    @Override
    public void refresh() {
        int value = 0;
        SectionItem item = this.getItem();
        if (item != null && (value = ((SectionItemContainer)item).getIdx()) == 0) {
            throw new DexException("Invalid reference: " + item);
        }
        this.item = item;
        this.set(value);
        this.updateItemUsage();
    }

    private void updateItemUsage() {
        T item = this.item;
        if (item != null) {
            ((SectionItem)item).addUsageType(this.usageType);
            ((DataItem)item).addUniqueUser(this);
        }
    }

    public void replaceKeys(Key search, Key replace) {
        Key key = this.getKey();
        if (key == null) {
            return;
        }
        Key key2 = key.replaceKey(search, replace);
        if (key != key2) {
            this.setKey(key2);
        }
    }

    @Override
    public void editInternal(Block user) {
        T item = this.getUniqueItem();
        if (item != null) {
            ((SectionItem)item).editInternal(this);
        }
    }

    public T getUniqueItem() {
        SectionItem item = this.getItem();
        if (item != null && ((DataItem)item).isSharedItem(this)) {
            item = this.createNewCopy();
        }
        return (T)item;
    }

    private T createNewCopy() {
        DataItem itemNew = (DataItem)this.getSectionTool().createSectionItem(this.getSectionType());
        this.copyToIfPresent(itemNew);
        this.setItem((T)itemNew);
        return (T)itemNew;
    }

    private void copyToIfPresent(T itemNew) {
        SectionItem item = this.getItem();
        if (item != null) {
            ((DataItem)itemNew).copyFrom((DataItem)item);
        }
    }

    @Override
    public T getOrCreate() {
        SectionItem item = this.getItem();
        if (item != null) {
            return (T)item;
        }
        item = (DataItem)this.getSectionTool().createSectionItem(this.getSectionType());
        this.setItem((T)item);
        return (T)item;
    }

    @Override
    public void unlink() {
        this.item = null;
        this.set(0);
    }

    @Override
    public void onReadBytes(BlockReader reader) throws IOException {
        super.onReadBytes(reader);
        this.pullItem();
    }

    @Override
    public String toString() {
        T item = this.item;
        if (item != null) {
            return this.get() + ":" + item.toString();
        }
        return this.getSectionType().getName() + ": " + this.get();
    }
}

