/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.apk.XmlHelper;
import com.reandroid.arsc.model.ResourceName;
import com.reandroid.arsc.value.AttributeDataFormat;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.ObjectsUtil;
import com.reandroid.utils.collection.ArrayCollection;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class DeclareStyleable
implements Comparable<DeclareStyleable>,
Iterable<Attr> {
    private final String name;
    private final ArrayCollection<Attr> attrList;
    public static final String TAG = ObjectsUtil.of("declare-styleable");
    public static final String NAME_format = ObjectsUtil.of("format");

    public DeclareStyleable(String name) {
        this.name = name;
        this.attrList = new ArrayCollection();
    }

    public String getName() {
        return this.name;
    }

    public List<Attr> getAttrList() {
        return this.attrList;
    }

    @Override
    public Iterator<Attr> iterator() {
        return this.getAttrList().iterator();
    }

    public int size() {
        return this.getAttrList().size();
    }

    public boolean isEmpty() {
        return this.getAttrList().isEmpty();
    }

    public void add(Attr attr) {
        ArrayCollection<Attr> attrList;
        if (attr != null && !(attrList = this.attrList).contains(attr)) {
            attrList.add(attr);
        }
    }

    public void serialize(XmlSerializer serializer) throws IOException {
        serializer.startTag(null, TAG);
        serializer.attribute(null, "name", this.getName());
        for (Attr attr : this) {
            attr.serialize(serializer);
        }
        XmlHelper.setIndent(serializer, true);
        serializer.endTag(null, TAG);
    }

    @Override
    public int compareTo(DeclareStyleable declareStyleable) {
        if (declareStyleable == this) {
            return 0;
        }
        return CompareUtil.compare(this.getName(), declareStyleable.getName());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DeclareStyleable that = (DeclareStyleable)obj;
        return ObjectsUtil.equals(this.getName(), that.getName()) && this.getAttrList().equals(that.getAttrList());
    }

    public int hashCode() {
        int result = ObjectsUtil.hash(this.getName());
        result = 31 * result + this.getAttrList().hashCode();
        return result;
    }

    public static void serialize(List<DeclareStyleable> styleableList, XmlSerializer serializer) throws IOException {
        serializer.startDocument("utf8", null);
        XmlHelper.setIndent(serializer, true);
        String tag = "resources";
        serializer.startTag(null, tag);
        for (DeclareStyleable styleable : styleableList) {
            styleable.serialize(serializer);
        }
        XmlHelper.setIndent(serializer, true);
        serializer.endTag(null, tag);
        serializer.endDocument();
    }

    public static class Attr {
        private final DeclareStyleable parent;
        private final int id;
        private final String name;
        private final String format;

        public Attr(DeclareStyleable parent, int id, String name, String format) {
            this.parent = parent;
            this.id = id;
            this.name = name;
            this.format = format;
        }

        public DeclareStyleable getParent() {
            return this.parent;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getFormat() {
            return this.format;
        }

        public int getFormatFlags() {
            return AttributeDataFormat.sum(AttributeDataFormat.parseValueTypes(this.getFormat()));
        }

        public int getIndex() {
            return this.getParent().getAttrList().indexOf(this);
        }

        public ResourceName toResourceName() {
            String name = this.getName();
            String packageName = null;
            int i = name.indexOf(58);
            if (i > 0) {
                packageName = name.substring(0, i);
                name = name.substring(i + 1);
            }
            return new ResourceName(packageName, "attr", name);
        }

        public void serialize(XmlSerializer serializer) throws IOException {
            String tag = "attr";
            serializer.startTag(null, tag);
            XmlHelper.setIndent(serializer, false);
            serializer.attribute(null, "name", this.getName());
            serializer.attribute(null, NAME_format, this.getFormat());
            XmlHelper.setIndent(serializer, true);
            serializer.endTag(null, tag);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            Attr attr = (Attr)obj;
            return this.id == attr.id;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            return "id=" + HexUtil.toHex8(this.id) + ", name='" + this.name + '\'' + ", format='" + this.format + '\'';
        }
    }
}

