/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.resource;

import com.reandroid.apk.XmlHelper;
import com.reandroid.arsc.chunk.TableBlock;
import com.reandroid.dex.dalvik.DalvikMemberClass;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.model.DexMethod;
import com.reandroid.dex.resource.RDeclareStyleable;
import com.reandroid.dex.resource.RStyleableType;
import com.reandroid.dex.resource.RType;
import com.reandroid.dex.resource.RTypeItem;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.utils.collection.ArrayCollection;
import com.reandroid.utils.collection.ComputeIterator;
import com.reandroid.utils.collection.InstanceIterator;
import com.reandroid.utils.collection.IterableIterator;
import com.reandroid.utils.collection.UniqueIterator;
import com.reandroid.xml.XMLFactory;
import java.io.IOException;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.List;
import org.xmlpull.v1.XmlSerializer;

public class R
implements Iterable<RTypeItem> {
    private final DexClass dexClass;
    private final ArrayCollection<RTypeItem> typeList;
    private boolean typeListLoaded;

    public R(DexClass dexClass) {
        this.dexClass = dexClass;
        this.typeList = new ArrayCollection();
    }

    @Override
    public Iterator<RTypeItem> iterator() {
        return this.getTypeList().iterator();
    }

    public Iterator<RStyleableType> getStyleables() {
        return InstanceIterator.of(this.getTypeList().iterator(), RStyleableType.class);
    }

    public Iterator<RDeclareStyleable> getRDeclareStyleables() {
        IterableIterator<RStyleableType, RDeclareStyleable> iterator = new IterableIterator<RStyleableType, RDeclareStyleable>(this.getStyleables()){

            @Override
            public Iterator<RDeclareStyleable> iterator(RStyleableType element) {
                return element.getRDeclareStyleables();
            }
        };
        return new UniqueIterator<RDeclareStyleable>((Iterator<RDeclareStyleable>)iterator);
    }

    public int size() {
        return this.getTypeList().size();
    }

    public List<RTypeItem> getTypeList() {
        this.loadTypes();
        return this.typeList;
    }

    private void loadTypes() {
        if (this.typeListLoaded) {
            return;
        }
        this.typeListLoaded = true;
        ArrayCollection<RTypeItem> typeList = this.typeList;
        typeList.clear();
        DexClassRepository repository = this.getDexClass().getClassRepository();
        typeList.addAll(ComputeIterator.of(repository.getDexClasses(), this::createWithCheck));
    }

    RTypeItem createWithCheck(DexClass dexClass) {
        if (this.isChild(dexClass)) {
            RTypeItem type = this.createType(dexClass);
            if (type != null && type.isValid()) {
                return type;
            }
            type = this.createStyleableType(dexClass);
            if (type != null && type.isValid()) {
                return type;
            }
        }
        return null;
    }

    RType createType(DexClass dexClass) {
        if (dexClass != null) {
            return new RType(dexClass);
        }
        return null;
    }

    RStyleableType createStyleableType(DexClass dexClass) {
        if (dexClass != null) {
            return new RStyleableType(dexClass);
        }
        return null;
    }

    boolean isChild(DexClass child) {
        TypeKey childKey;
        if (child == null || child.isAbstract() || child.isInterface() || child.isEnum()) {
            return false;
        }
        TypeKey typeKey = this.getKey();
        if (typeKey.equals(childKey = child.getKey())) {
            return false;
        }
        if (!typeKey.equalsPackage(childKey)) {
            return false;
        }
        if (this.containsOnMembers(typeKey)) {
            return true;
        }
        return typeKey.equals(childKey.getEnclosingClass());
    }

    private boolean containsOnMembers(TypeKey typeKey) {
        DalvikMemberClass dalvikMemberClass = DalvikMemberClass.of(this.getDexClass());
        if (dalvikMemberClass != null) {
            return dalvikMemberClass.contains(typeKey);
        }
        return false;
    }

    public String getName() {
        return this.getKey().getSimpleInnerName();
    }

    public TypeKey getKey() {
        return this.getDexClass().getKey();
    }

    public DexClass getDexClass() {
        return this.dexClass;
    }

    public void refresh() {
        this.typeListLoaded = false;
        this.loadTypes();
    }

    public boolean isValid() {
        DexClass dexClass = this.getDexClass();
        if (dexClass.isAbstract() || dexClass.isInterface() || dexClass.isEnum() || dexClass.isSynthetic()) {
            return false;
        }
        if (dexClass.getDeclaredFields().hasNext()) {
            return false;
        }
        Iterator<DexMethod> declaredMethods = dexClass.getDeclaredMethods();
        while (declaredMethods.hasNext()) {
            DexMethod dexMethod = declaredMethods.next();
            if (dexMethod.isConstructor()) continue;
            return false;
        }
        return this.isTypesValid();
    }

    private boolean isTypesValid() {
        boolean types = false;
        for (RTypeItem type : this) {
            if (!type.isValid()) {
                return false;
            }
            types = true;
        }
        return types;
    }

    public String toJavaString() {
        StringWriter stringWriter = new StringWriter();
        SmaliWriter writer = new SmaliWriter();
        writer.setWriter(stringWriter);
        try {
            this.appendJava(writer);
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return stringWriter.toString();
    }

    public void appendJava(SmaliWriter writer) throws IOException {
        this.loadTypes();
        DexClass dexClass = this.getDexClass();
        writer.append("package ");
        writer.append(dexClass.getKey().getPackageSourceName());
        writer.append(';');
        writer.newLine();
        writer.newLine();
        writer.appendModifiers(dexClass.getAccessFlags());
        writer.append("class ");
        writer.append(this.getName());
        writer.append(" {");
        writer.indentPlus();
        for (RTypeItem typeItem : this) {
            writer.newLine();
            typeItem.appendJava(writer);
        }
        writer.indentMinus();
        writer.newLine();
        writer.append('}');
    }

    public String toXml(TableBlock tableBlock) throws IOException {
        StringWriter writer = new StringWriter();
        XmlSerializer serializer = XMLFactory.newSerializer(writer);
        this.serialize(tableBlock, serializer);
        serializer.flush();
        writer.close();
        return writer.toString();
    }

    public void serialize(TableBlock tableBlock, XmlSerializer serializer) throws IOException {
        serializer.startDocument("utf8", null);
        XmlHelper.setIndent(serializer, true);
        String tag = "resources";
        serializer.startTag(null, tag);
        Iterator<RDeclareStyleable> iterator = this.getRDeclareStyleables();
        while (iterator.hasNext()) {
            RDeclareStyleable attributes = iterator.next();
            attributes.serialize(tableBlock, serializer);
        }
        serializer.endTag(null, tag);
        serializer.endDocument();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof R)) {
            return false;
        }
        R other = (R)obj;
        return this.getKey().equals(other.getKey());
    }

    public int hashCode() {
        return this.getKey().hashCode();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        boolean loaded = this.typeListLoaded;
        if (!loaded) {
            builder.append("NOT-LOADED: ");
        }
        builder.append(this.getKey());
        if (loaded) {
            builder.append(", size = ");
            builder.append(this.size());
        }
        return builder.toString();
    }

    static R createValid(DexClass dexClass) {
        R r = R.create(dexClass);
        if (r != null && r.isValid()) {
            return r;
        }
        return null;
    }

    static R create(DexClass dexClass) {
        if (dexClass != null) {
            return new R(dexClass);
        }
        return null;
    }

    public static Iterator<R> findAll(DexClassRepository repository) {
        return R.findAll(repository.getDexClasses());
    }

    public static Iterator<R> findAll(Iterator<? extends DexClass> iterator) {
        return ComputeIterator.of(iterator, R::createValid);
    }
}

