/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.sections;

import com.reandroid.arsc.base.Creator;
import com.reandroid.arsc.io.BlockReader;
import com.reandroid.arsc.item.IntegerReference;
import com.reandroid.dex.base.IntegerPair;
import com.reandroid.dex.common.SectionItemContainer;
import com.reandroid.dex.data.DataItem;
import com.reandroid.dex.sections.SectionArray;
import java.io.IOException;

public class DataSectionArray<T extends DataItem>
extends SectionArray<T> {
    public DataSectionArray(IntegerPair countAndOffset, Creator<T> creator) {
        super(countAndOffset, creator);
    }

    public T getAt(int offset) {
        if (offset <= 0) {
            return null;
        }
        T item = this.binaryOffsetSearch(offset);
        if (item == null) {
            item = this.lazyOffsetSearch(offset);
        }
        return item;
    }

    private T binaryOffsetSearch(int offset) {
        int start = 0;
        int end = this.size() - 1;
        while (end >= start) {
            int mid = start + (end - start) / 2;
            DataItem item = (DataItem)this.get(mid);
            int test = item.getOffset();
            if (test == offset) {
                return (T)item;
            }
            if (test < offset) {
                start = mid + 1;
                continue;
            }
            end = mid - 1;
        }
        return null;
    }

    private T lazyOffsetSearch(int offset) {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            DataItem item = (DataItem)this.get(i);
            if (offset != item.getOffset()) continue;
            return (T)item;
        }
        return null;
    }

    @Override
    public void readChild(BlockReader reader, T item) throws IOException {
        int offset = reader.getPosition();
        ((SectionItemContainer)item).setPosition(offset);
        ((SectionItemContainer)item).onReadBytes(reader);
    }

    @Override
    public void onPreRemove(T item) {
        super.onPreRemove(item);
        IntegerReference reference = ((SectionItemContainer)item).getOffsetReference();
        if (reference != null) {
            reference.set(0);
        }
    }
}

