/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.formatters;

import com.reandroid.dex.ins.Label;
import com.reandroid.utils.CompareUtil;
import com.reandroid.utils.HexUtil;
import com.reandroid.utils.collection.ArrayCollection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class SequentialLabelFactory {
    private final Map<String, String> labelMap = new HashMap<String, String>();

    public void build(Iterator<? extends Label> iterator) {
        this.reset();
        HashMap<String, HashSet<String>> groupMap = new HashMap<String, HashSet<String>>();
        while (iterator.hasNext()) {
            String name = iterator.next().getLabelName();
            String key = this.dropSuffix(name);
            if (key == null) continue;
            HashSet<String> group = (HashSet<String>)groupMap.get(key);
            if (group == null) {
                group = new HashSet<String>();
                groupMap.put(key, group);
            }
            group.add(name);
        }
        for (Map.Entry entry : groupMap.entrySet()) {
            this.build((String)entry.getKey(), (Set)entry.getValue());
        }
    }

    private void build(String key, Set<String> group) {
        Map<String, String> labelMap = this.labelMap;
        ArrayCollection<String> list = new ArrayCollection<String>(group);
        list.sort((s, t1) -> CompareUtil.compare(SequentialLabelFactory.getLabelSuffix(s), SequentialLabelFactory.getLabelSuffix(t1)));
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            labelMap.put((String)list.get(i), HexUtil.toHex(key, i, 1));
        }
    }

    private String dropSuffix(String name) {
        int i;
        if (name.length() != 0 && name.charAt(0) == ':' && (i = name.lastIndexOf(95)) > 0) {
            return name.substring(0, i + 1);
        }
        return null;
    }

    static int getLabelSuffix(String name) {
        int i;
        if (name.length() != 0 && name.charAt(0) == ':' && (i = name.lastIndexOf(95)) > 0) {
            return HexUtil.decodeHex(name.substring(i + 1), 0);
        }
        return 0;
    }

    public void reset() {
        this.labelMap.clear();
    }

    public String get(String label) {
        String result = this.labelMap.get(label);
        if (result == null) {
            return label;
        }
        return result;
    }
}

