/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.ins.Opcode;
import com.reandroid.dex.smali.SmaliDirective;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliCode;
import com.reandroid.dex.smali.model.SmaliCodeTryItem;
import com.reandroid.dex.smali.model.SmaliDebug;
import com.reandroid.dex.smali.model.SmaliDebugElement;
import com.reandroid.dex.smali.model.SmaliDebugEndLocal;
import com.reandroid.dex.smali.model.SmaliDebugEpilogue;
import com.reandroid.dex.smali.model.SmaliDebugLocal;
import com.reandroid.dex.smali.model.SmaliDebugPrologue;
import com.reandroid.dex.smali.model.SmaliDebugRestartLocal;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliLineNumber;
import com.reandroid.dex.smali.model.SmaliMethodParameter;
import com.reandroid.dex.smali.model.SmaliNullInstruction;
import com.reandroid.dex.smali.model.SmaliPayloadArray;
import com.reandroid.dex.smali.model.SmaliPayloadPackedSwitch;
import com.reandroid.dex.smali.model.SmaliPayloadSparseSwitch;
import com.reandroid.dex.smali.model.SmaliSet;
import com.reandroid.utils.collection.EmptyIterator;
import com.reandroid.utils.collection.FilterIterator;
import java.io.IOException;
import java.util.Iterator;

public class SmaliCodeSet
extends SmaliSet<SmaliCode> {
    private int addressOffset;
    private SmaliNullInstruction nullInstruction;

    public int getAddressOffset() {
        return this.addressOffset;
    }

    public void setAddressOffset(int addressOffset) {
        this.addressOffset = addressOffset;
    }

    public void updateAddresses() {
        int address = this.getAddressOffset();
        Iterator<SmaliInstruction> iterator = this.getInstructions();
        while (iterator.hasNext()) {
            SmaliInstruction ins = iterator.next();
            ins.setAddress(address);
            address += ins.getCodeUnits();
        }
        SmaliInstruction instruction = this.getNullInstruction();
        if (instruction != null) {
            instruction.setAddress(address);
        }
    }

    public Iterator<SmaliInstruction> getInstructions(SmaliLabel label) {
        if (label != null) {
            return FilterIterator.of(this.getInstructions(), smaliInstruction -> smaliInstruction.hasLabelOperand(label));
        }
        return EmptyIterator.of();
    }

    public Iterator<SmaliInstruction> getInstructions() {
        return this.iterator(SmaliInstruction.class);
    }

    public Iterator<SmaliCodeTryItem> getTryItems() {
        return this.iterator(SmaliCodeTryItem.class);
    }

    public Iterator<SmaliDebug> getDebugs() {
        return this.iterator(SmaliDebug.class);
    }

    public Iterator<SmaliDebugElement> getDebugElements() {
        return this.iterator(SmaliDebugElement.class);
    }

    public Iterator<SmaliMethodParameter> getMethodParameters() {
        return this.iterator(SmaliMethodParameter.class);
    }

    public void clearInstructions() {
        this.removeInstances(SmaliDebug.class);
    }

    public void clearDebugs() {
        this.removeInstances(SmaliDebug.class);
    }

    public SmaliInstruction getNullInstruction() {
        SmaliNullInstruction nullInstruction = this.nullInstruction;
        if (this.needsNullInstruction()) {
            if (nullInstruction == null) {
                nullInstruction = new SmaliNullInstruction();
                nullInstruction.setParent(this);
                this.nullInstruction = nullInstruction;
            }
        } else if (nullInstruction != null) {
            nullInstruction.setParent(null);
            nullInstruction = null;
            this.nullInstruction = null;
        }
        return nullInstruction;
    }

    private boolean needsNullInstruction() {
        if (this.isEmpty()) {
            return false;
        }
        return !(this.get(this.size() - 1) instanceof SmaliInstruction);
    }

    public SmaliInstruction newInstruction(Opcode<?> opcode) {
        SmaliInstruction instruction = SmaliCodeSet.createInstruction(opcode);
        this.add(instruction);
        return instruction;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        if (this.isEmpty()) {
            return;
        }
        writer.newLine();
        writer.appendAll(this.iterator());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        super.parse(reader);
        this.updateAddresses();
    }

    @Override
    SmaliCode createNext(SmaliReader reader) {
        SmaliDirective directive = SmaliDirective.parse(reader, false);
        if (directive != null) {
            return SmaliCodeSet.createFor(directive);
        }
        reader.skipWhitespaces();
        if (reader.get() == 58) {
            return new SmaliLabel();
        }
        Opcode<?> opcode = Opcode.parseSmali(reader, false);
        if (opcode != null) {
            return new SmaliInstruction();
        }
        return null;
    }

    private static SmaliCode createFor(SmaliDirective directive) {
        if (directive == SmaliDirective.LINE) {
            return new SmaliLineNumber();
        }
        if (directive == SmaliDirective.CATCH || directive == SmaliDirective.CATCH_ALL) {
            return new SmaliCodeTryItem();
        }
        if (directive == SmaliDirective.PARAM) {
            return new SmaliMethodParameter();
        }
        if (directive == SmaliDirective.END_LOCAL) {
            return new SmaliDebugEndLocal();
        }
        if (directive == SmaliDirective.LOCAL) {
            return new SmaliDebugLocal();
        }
        if (directive == SmaliDirective.RESTART_LOCAL) {
            return new SmaliDebugRestartLocal();
        }
        if (directive == SmaliDirective.ARRAY_DATA) {
            return new SmaliPayloadArray();
        }
        if (directive == SmaliDirective.PACKED_SWITCH) {
            return new SmaliPayloadPackedSwitch();
        }
        if (directive == SmaliDirective.SPARSE_SWITCH) {
            return new SmaliPayloadSparseSwitch();
        }
        if (directive == SmaliDirective.PROLOGUE) {
            return new SmaliDebugPrologue();
        }
        if (directive == SmaliDirective.EPILOGUE) {
            return new SmaliDebugEpilogue();
        }
        return null;
    }

    public static SmaliInstruction createInstruction(Opcode<?> opcode) {
        SmaliInstruction instruction = opcode == Opcode.ARRAY_PAYLOAD ? new SmaliPayloadArray() : (opcode == Opcode.PACKED_SWITCH_PAYLOAD ? new SmaliPayloadPackedSwitch() : (opcode == Opcode.SPARSE_SWITCH_PAYLOAD ? new SmaliPayloadSparseSwitch() : new SmaliInstruction(opcode)));
        return instruction;
    }
}

