/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.debug.DebugElementType;
import com.reandroid.dex.debug.DebugStartLocal;
import com.reandroid.dex.key.StringKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliDebugRegister;
import java.io.IOException;

public class SmaliDebugLocal
extends SmaliDebugRegister {
    private StringKey name;
    private TypeKey type;
    private StringKey signature;

    public StringKey getName() {
        return this.name;
    }

    public void setName(StringKey name) {
        this.name = name;
    }

    public TypeKey getType() {
        return this.type;
    }

    public void setType(TypeKey type) {
        this.type = type;
    }

    public StringKey getSignature() {
        return this.signature;
    }

    public void setSignature(StringKey signature) {
        this.signature = signature;
    }

    public boolean isExtended() {
        return this.signature != null;
    }

    public DebugElementType<? extends DebugStartLocal> getDebugElementType() {
        if (this.isExtended()) {
            return DebugElementType.START_LOCAL_EXTENDED;
        }
        return DebugElementType.START_LOCAL;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        super.append(writer);
        writer.append(", ");
        writer.appendOptional(this.getName());
        writer.append(':');
        writer.appendOptional(this.getType());
        StringKey signature = this.getSignature();
        if (signature != null) {
            writer.append(", ");
            signature.append(writer);
        }
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        super.parse(reader);
        reader.skipWhitespacesOrComment();
        SmaliParseException.expect(reader, ',');
        reader.skipWhitespacesOrComment();
        this.setName(StringKey.read(reader));
        reader.skipSpaces();
        SmaliParseException.expect(reader, ':');
        reader.skipSpaces();
        this.setType(TypeKey.read(reader));
        reader.skipSpaces();
        if (reader.get() == 44) {
            reader.skip(1);
            reader.skipWhitespacesOrComment();
            this.setSignature(StringKey.read(reader));
        }
    }
}

