/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.smali.model.Smali;
import com.reandroid.dex.smali.model.SmaliInstruction;
import com.reandroid.dex.smali.model.SmaliLabel;
import com.reandroid.dex.smali.model.SmaliSwitchPayload;
import com.reandroid.utils.ObjectsUtil;

public abstract class SmaliSwitchEntry
extends Smali {
    private final SmaliLabel label = new SmaliLabel();

    public SmaliSwitchEntry() {
        this.label.setParent(this);
    }

    public SmaliLabel getLabel() {
        return this.label;
    }

    public Integer getRelativeOffset() {
        SmaliInstruction target;
        SmaliInstruction switchInstruction = this.getSwitch();
        if (switchInstruction != null && (target = this.getTargetInstruction()) != null) {
            return target.getAddress() - switchInstruction.getAddress();
        }
        return null;
    }

    public SmaliInstruction getTargetInstruction() {
        return this.getLabel().getTargetInstruction();
    }

    public SmaliInstruction getSwitch() {
        SmaliSwitchPayload<?> payload = this.getPayload();
        if (payload != null) {
            return payload.getSwitch();
        }
        return null;
    }

    public SmaliSwitchPayload<?> getPayload() {
        return (SmaliSwitchPayload)ObjectsUtil.cast(this.getParentInstance(SmaliSwitchPayload.class));
    }
}

