/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.smali.model;

import com.reandroid.dex.common.DexUtils;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.smali.SmaliParseException;
import com.reandroid.dex.smali.SmaliReader;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class SmaliValueChar
extends SmaliValue {
    private char value;

    public char getValue() {
        return this.value;
    }

    public void setValue(char value) {
        this.value = value;
    }

    @Override
    public Key getKey() {
        return PrimitiveKey.of(this.getValue());
    }

    @Override
    public void setKey(Key key) {
        this.setValue(((PrimitiveKey.CharKey)key).value());
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.CHAR;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        DexUtils.appendSingleQuotedChar(writer, this.getValue());
    }

    @Override
    public void parse(SmaliReader reader) throws IOException {
        reader.skipSpaces();
        if (reader.read() != 39) {
            reader.skip(-1);
            throw new SmaliParseException("Missing start \"'\"", reader);
        }
        int ch = reader.readASCII();
        if (ch == 92) {
            ch = reader.readASCII();
            if (ch == 117) {
                try {
                    int i = HexUtil.parseHex(reader.readString(4));
                    ch = (char)i;
                }
                catch (NumberFormatException ex) {
                    reader.skip(-4);
                    throw new SmaliParseException("Invalid four-char hex encoded char", reader);
                }
            } else {
                switch (ch) {
                    case 98: {
                        ch = 8;
                        break;
                    }
                    case 102: {
                        ch = 12;
                        break;
                    }
                    case 110: {
                        ch = 10;
                        break;
                    }
                    case 114: {
                        ch = 13;
                        break;
                    }
                    case 116: {
                        ch = 9;
                    }
                }
            }
        }
        this.setValue((char)ch);
        if (reader.read() != 39) {
            reader.skip(-2);
            throw new SmaliParseException("Missing end \"'\"", reader);
        }
    }
}

