/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.tools;

import com.reandroid.dex.id.FieldId;
import com.reandroid.dex.id.MethodId;
import com.reandroid.dex.key.FieldKey;
import com.reandroid.dex.key.MethodKey;
import com.reandroid.dex.model.DexClass;
import com.reandroid.dex.model.DexClassRepository;
import com.reandroid.dex.sections.SectionType;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class DexValidator {
    private final DexClassRepository classRepository;

    public DexValidator(DexClassRepository classRepository) {
        this.classRepository = classRepository;
    }

    public Set<FieldKey> findMissingOrInaccessibleFields() {
        HashSet<FieldKey> results = new HashSet<FieldKey>();
        DexClassRepository classRepository = this.getClassRepository();
        Iterator<FieldId> iterator = classRepository.getItems(SectionType.FIELD_ID);
        while (iterator.hasNext()) {
            DexClass declaring;
            FieldKey key = iterator.next().getKey();
            if (results.contains(key) || (declaring = classRepository.getDexClass(key.getDeclaring())) == null || declaring.getField(key) != null) continue;
            results.add(key);
        }
        return results;
    }

    public Set<MethodKey> findMissingOrInaccessibleMethods() {
        HashSet<MethodKey> results = new HashSet<MethodKey>();
        DexClassRepository classRepository = this.getClassRepository();
        Iterator<MethodId> iterator = classRepository.getItems(SectionType.METHOD_ID);
        while (iterator.hasNext()) {
            DexClass declaring;
            MethodKey key = iterator.next().getKey();
            if (results.contains(key) || (declaring = classRepository.getDexClass(key.getDeclaring())) == null || declaring.getMethod(key) != null) continue;
            results.add(key);
        }
        return results;
    }

    private DexClassRepository getClassRepository() {
        return this.classRepository;
    }
}

