/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.arsc.base.Block;
import com.reandroid.dex.data.EncodedArray;
import com.reandroid.dex.id.IdItem;
import com.reandroid.dex.key.ArrayValueKey;
import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueArray;
import com.reandroid.dex.value.DexValueBlock;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.utils.collection.IterableIterator;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Predicate;

public class ArrayValue
extends DexValueBlock<EncodedArray>
implements Iterable<DexValueBlock<?>> {
    public ArrayValue() {
        super(new EncodedArray(), DexValueType.ARRAY);
    }

    public Key getKey(int i) {
        DexValueBlock<?> value = this.get(i);
        if (value != null) {
            return value.getKey();
        }
        return null;
    }

    public DexValueBlock<?> get(int i) {
        return ((EncodedArray)this.getValueContainer()).get(i);
    }

    public int size() {
        return ((EncodedArray)this.getValueContainer()).size();
    }

    public void add(DexValueBlock<?> value) {
        ((EncodedArray)this.getValueContainer()).add(value);
    }

    public boolean remove(int index) {
        return ((EncodedArray)this.getValueContainer()).remove(index);
    }

    public boolean remove(DexValueBlock<?> value) {
        return ((EncodedArray)this.getValueContainer()).remove(value);
    }

    public boolean removeIf(Predicate<? super DexValueBlock<?>> filter) {
        return ((EncodedArray)this.getValueContainer()).removeIf(filter);
    }

    public <T1 extends DexValueBlock<?>> T1 createNext(DexValueType<T1> valueType) {
        Block item = valueType.newInstance();
        this.add((DexValueBlock<?>)item);
        return (T1)item;
    }

    public void clear() {
        ((EncodedArray)this.getValueContainer()).clear();
    }

    @Override
    public Iterator<DexValueBlock<?>> iterator() {
        return ((EncodedArray)this.getValueContainer()).iterator();
    }

    public <T1 extends DexValueBlock<?>> Iterator<T1> iterator(Class<T1> instance) {
        return ((EncodedArray)this.getValueContainer()).iterator(instance);
    }

    public <T1 extends DexValueBlock<?>> Iterator<T1> iterator(Class<T1> instance, Predicate<? super T1> filter) {
        return ((EncodedArray)this.getValueContainer()).iterator(instance, filter);
    }

    public Iterator<DexValueBlock<?>> clonedIterator() {
        return ((EncodedArray)this.getValueContainer()).clonedIterator();
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.ARRAY;
    }

    @Override
    public Iterator<IdItem> usedIds() {
        return new IterableIterator<DexValueBlock<?>, IdItem>(this.iterator()){

            @Override
            public Iterator<IdItem> iterator(DexValueBlock<?> element) {
                return element.usedIds();
            }
        };
    }

    @Override
    public void replaceKeys(Key search, Key replace) {
        for (DexValueBlock<?> valueBlock : this) {
            valueBlock.replaceKeys(search, replace);
        }
    }

    @Override
    public ArrayValueKey getKey() {
        return ((EncodedArray)this.getValueContainer()).getKey();
    }

    @Override
    public void setKey(Key key) {
        ((EncodedArray)this.getValueContainer()).setKey(key);
    }

    @Override
    public void merge(DexValueBlock<?> valueBlock) {
        super.merge(valueBlock);
        ArrayValue coming = (ArrayValue)valueBlock;
        ((EncodedArray)this.getValueContainer()).merge((EncodedArray)coming.getValueContainer());
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueArray smaliValueArray = (SmaliValueArray)smaliValue;
        for (SmaliValue smaliValueChild : smaliValueArray) {
            Object value = this.createNext(smaliValueChild.getValueType());
            ((DexValueBlock)value).fromSmali(smaliValueChild);
        }
    }

    @Override
    public TypeKey getDataTypeKey() {
        DexValueBlock<?> valueBlock = this.get(0);
        if (valueBlock != null) {
            TypeKey typeKey = valueBlock.getDataTypeKey();
            return typeKey.setArrayDimension(typeKey.getArrayDimension() + 1);
        }
        return TypeKey.OBJECT.setArrayDimension(1);
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.append('{');
        writer.indentPlus();
        int count = this.size();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                writer.append(',');
            }
            writer.newLine();
            this.get(i).append(writer);
        }
        writer.indentMinus();
        if (count > 0) {
            writer.newLine();
        }
        writer.append('}');
    }
}

