/*
 * Decompiled with CFR 0.152.
 */
package com.reandroid.dex.value;

import com.reandroid.dex.key.Key;
import com.reandroid.dex.key.PrimitiveKey;
import com.reandroid.dex.key.TypeKey;
import com.reandroid.dex.smali.SmaliWriter;
import com.reandroid.dex.smali.model.SmaliValue;
import com.reandroid.dex.smali.model.SmaliValueByte;
import com.reandroid.dex.value.DexValueType;
import com.reandroid.dex.value.PrimitiveValueBlock;
import com.reandroid.utils.HexUtil;
import java.io.IOException;

public class ByteValue
extends PrimitiveValueBlock {
    public ByteValue() {
        super(DexValueType.BYTE);
    }

    public byte get() {
        return (byte)this.getSignedValue();
    }

    public void set(byte b) {
        this.setNumberValue(b);
    }

    @Override
    public DexValueType<?> getValueType() {
        return DexValueType.BYTE;
    }

    @Override
    public PrimitiveKey getKey() {
        return PrimitiveKey.of(this.get());
    }

    @Override
    public void setKey(Key key) {
        this.set(((PrimitiveKey.ByteKey)key).value());
    }

    @Override
    public TypeKey getDataTypeKey() {
        return TypeKey.TYPE_B;
    }

    @Override
    public void append(SmaliWriter writer) throws IOException {
        writer.appendHex(this.get());
    }

    @Override
    public void fromSmali(SmaliValue smaliValue) {
        SmaliValueByte smaliValueByte = (SmaliValueByte)smaliValue;
        this.set(smaliValueByte.getValue());
    }

    @Override
    public String toString() {
        return HexUtil.toSignedHex(this.get()) + "t";
    }
}

